/*
 * democopy	copy a file to/from multiple diskettes.
 *
 * This is a sample program used to illustrate the multi-disk i/o
 * (mdio) package.  The prompt routines are used to check for the
 * continuation of a file.  These are guaranteed to be called
 * after no more bytes can be transferred to/from a file.
 *
 * When writing a file, after a diskette is full, the file is closed
 * and the `output' prompt routine is called.  This creates an empty
 * file with an extension of .TBC (to-be-continued), and asks for the
 * next diskette.
 *
 * When reading a file, at EOF, the `at eof' function is called.
 * This looks for a file with a .TBC extension, and if found returns
 * FALSE since we are not really at EOF.  If this file is NOT found
 * then we are really at EOF, so TRUE is returned.
 *
 * After the input file is closed, the `input' prompt routine is
 * called which asks the user to insert the next diskette for the file.
 *
 * Note:  using an extension can be ambiguous, but this is only a
 *        sample program.
 *
 * March 1989	created by greg yachuk.  placed in the public domain.
 */
#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "mdiskio.h"

/* these two guys are global for debugging purposes */
MDFILE *ip, *op;

main(argc, argv)
int	argc;
char  **argv;
{
	char	buf[BUFSIZ];
	int	len;
	int	inprompt();
	int	ateof();
	int	outprompt();

	if (argc != 3)
	{
		puts("usage: mdcopy srcfile dstfile");
		exit(1);
	}

	if ((ip = mdopen(argv[1], "rb", NULL, 0)) == NULL)
	{
		perror(argv[1]);
		exit(2);
	}

	if ((op = mdopen(argv[2], "wb", NULL, 0)) == NULL)
	{
		perror(argv[2]);
		exit(3);
	}

	/* set buffer sizes to 16K each */

	mdsetbuf(ip, 16*1024);
	mdsetbuf(op, 16*1024);

	/* override the default "prompt" routines */

	mdfnateof(ip, ateof);
	mdfnprompt(ip, inprompt);
	mdfnprompt(op, outprompt);

	/* and copy away... */
#ifdef	PROFILE
	PRFstart((long far *) main);
#endif
	while (!mdeof(ip))
	{
		len = mdread(buf, sizeof (char), sizeof buf, ip);
		if (mdwrite(buf, sizeof (char), len, op) != len)
			break;
	}
#ifdef	PROFILE
	PRFstop();
#endif
	/* alternative copy... */

	while (!mdeof(ip) && !mdeof(op))
		mdputc(mdgetc(ip), op);

	/* gotta make sure we close, cause this flushes the buffers */

	mdclose(ip);
	mdclose(op);

	exit(0);
}

/*
 * contfnm -	construct the name of the `to-be-continued' marker file.
 *		this is constructed from the basename with an extension
 *		of `tbc' (to-be-continued).
 */
char   *
contfnm(mdp)
MDFILE *mdp;
{
	static char contfile[256];
	char   *base;
	char   *dotp;

	/* copy the basename */
	strcpy(contfile, mdp->basename);

	/* strip off the drive and path from the tail */
	if ((base = strrchr(contfile, '/')) == NULL)
		base = contfile;
#ifdef	DOS
	/* this is DOS, y'know.  it allows both / and \ */
	if ((dotp = strrchr(base, '\\')) == NULL)
		dotp = base;
#endif
	/* scan for the '.' */
	for (; *dotp && *dotp != '.'; ++dotp);

	/* and add the new extension */
	*dotp++ = '.';
	*dotp++ = 't';
	*dotp++ = 'b';
	*dotp++ = 'c';
	*dotp = '\0';

	return (contfile);
}

/*
 * ateof -	this routine is called when EOF is reached while
 *		reading the input file.  We check if we need to
 *		ask for a new diskette, by checking for the existence
 *		of a `.tbc' (to-be-continued) file.
 */
ateof(mdp, mode)
MDFILE *mdp;
int	mode;
{
	return (access(contfnm(mdp), 00));
}

/*
 * inprompt -	this routine is called when EOF of a diskette is
 *		found, but there is supposed to be another diskette.
 *		it prompts for the next diskette and waits for the
 *		user to enter a carriage-return.
 */
inprompt(mdp)
MDFILE *mdp;
{
	/* ask for another diskette, and wait for a response */
	fputs("Please insert next diskette for ", stderr);
	fputs(mdp->basename, stderr);
	fputs(" and press ENTER...", stderr);

	while (getchar() != '\n');

	/* all ready to go with the next diskette */

	return (1);
}

/*
 * outprompt -	this routine is called when no more bytes can be
 *		written to a file.  we create a `.tbc' (to-be-
 *		continued) file on the same diskette.  Luckily,
 *		DOS still has room to create a file when all the
 *		disk space is gone.  Then ask for a new diskette.
 */
outprompt(mdp)
MDFILE *mdp;
{
	char   *contfile;
	int	fd;

	/* get the name of the to-be-continued file */
	contfile = contfnm(mdp);

	/* create the to-be-continued file */
	fd = open(contfile, O_CREAT|O_WRONLY, S_IREAD|S_IWRITE);
	if (fd == -1)
	{
		perror(contfile);	/* something drastic went wrong */
		return (0);		/* can't continue this file */
	}

	close(fd);

	/* ask for another diskette and wait for a response */
	_mdprompt(mdp);

	/* all ready to go with next diskette */

	return (1);
}
