/*
 * unixcopy	split a file into multiple parts
 *
 * This is a sample program used to illustrate the multi-disk i/o
 * (mdio) package.  By setting a limit on the filesize, a large file
 * can be split into multiple small files.  I know, I know.  This can
 * already be done with split, but this is only a demonstration.  It
 * can also reassemble the parts into a whole.  Again, this is only a
 * demonstration.
 *
 * When writing a file, after a file is full the file is closed and
 * the `output' prompt routine is called.  This is completely silent.
 * As the next file is opened, the `filenm' function computes a new
 * filename.  The initial file is named as specified.  Subsequent files
 * have an extension created from the sequence number (.002, .003, etc).
 *
 * When reading a file, at EOF, the `at eof' function is called.  This
 * looks for a file with same basename, and an extension of the next
 * sequence number.  If found, it returns FALSE since we are not really
 * at EOF.  If this file is NOT found then we are really at EOF, so TRUE
 * is returned.
 *
 * Note:  using an extension can be ambiguous, but this is only a
 *        sample program.
 *
 * March 1989	created by greg yachuk.  placed in the public domain.
 */
#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "mdiskio.h"

/* these two guys are global for debugging purposes */
MDFILE *ip, *op;

main(argc, argv)
int	argc;
char  **argv;
{
	char	buf[BUFSIZ];
	int	len;
	int	ateof();
	char   *filenm();
	int	prompt();

	if (argc != 3)
	{
		puts("usage: unixcopy srcfile dstfile");
		exit(1);
	}

	/* filename, READ, no filename function, sequence starts at 1 */
	if ((ip = mdopen(argv[1], "r", NULL, 1)) == NULL)
	{
		perror(argv[1]);
		exit(2);
	}

	/* filename, WRITE, no filename function, sequence starts at 1 */
	if ((op = mdopen(argv[2], "w", NULL, 1)) == NULL)
	{
		perror(argv[2]);
		exit(3);
	}

	/* set buffer sizes to 16K each */

	mdsetbuf(ip, 16*1024);
	mdsetbuf(op, 16*1024);

	/* override the default "prompt" routines */

	mdfnateof(ip, ateof);
	mdfnprompt(ip, prompt);
	mdfnprompt(op, prompt);
	mdfnfilenm(ip, filenm);
	mdfnfilenm(op, filenm);

	/* and copy away... */
#ifdef	PROFILE
	PRFstart((long far *) main);
#endif
	while (!mdeof(ip))
	{
		len = mdread(buf, sizeof (char), sizeof buf, ip);
		if (mdwrite(buf, sizeof (char), len, op) != len)
			break;
	}
#ifdef	PROFILE
	PRFstop();
#endif
	/* alternative copy... */

	while (!mdeof(ip) && !mdeof(op))
		mdputc(mdgetc(ip), op);

	/* gotta make sure we close, cause this flushes the buffers */

	mdclose(ip);
	mdclose(op);

	exit(0);
}

/*
 * filefnm -	construct the name of the next file to be opened in
 *		sequence.  It consists of the base filename followed
 *		by a three character extension.
 */
char   *
filenm(mdp)
MDFILE *mdp;
{
	static char filename[256];
	char   *base;

	/* copy the basename */
	strcpy(filename, mdp->basename);

	/* isolate the base, without preceding path */
	if ((base = strrchr(filename, '/')) == NULL)
		base = filename;

	/* remove any extension */
	if ((base = strrchr(base, '.')) == NULL)
		base = filename + strlen(filename);

	sprintf(base, ".%.3d", ++mdp->seq);
	return (filename);
}

/*
 * ateof -	this routine is called when EOF is reached while reading
 *		the input file.  We check for the existence of the next
 *		file in sequence.
 */
ateof(mdp, mode)
MDFILE *mdp;
int	mode;
{
	char   *fname;
	struct stat buf;

	fname = filenm(mdp);
	--mdp->seq;
	return (stat(fname, &buf));
}

/*
 * prompt -	completely silent.
 */
prompt(mdp)
MDFILE *mdp;
{
	return (1);
}
