/*
 * Created 1989 by greg yachuk.  Placed in the public domain.
 */

#include <stdio.h>
#include <fcntl.h>
#ifdef	MSDOS
#include <io.h>
#endif

#include "mdiskio.h"

/*
 * mdtell -	tell the current offset from the beginning of the file.
 *		Note:	this is relative to the file segment ON THE
 *			CURRENT DISKETTE.
 */
long
mdtell(mdp)
MDFILE *mdp;
{
	if (mdp->buffer == NULL)
		return (tell(mdp->fid));

	if (mdp->flags & _MDWRITE)
		return (tell(mdp->fid) + mdp->bufptr - mdp->buffer);

	return (tell(mdp->fid) - mdp->bufcnt);
}

/*
 * mdseek -	set the current position relative to the beginning of
 *		the file, the current position, or end of file.
 *		return the new position relative to the beginning of file.
 *
 *		Note:	You cannot seek across diskette boundaries.
 */
long
mdseek(mdp, c, orig)
MDFILE *mdp;
long	c;
int	orig;
{
	long	posn = 0;

	/* just return raw position, if we haven't buffered anything */
	if (mdp->buffer == NULL)
		return (lseek(mdp->fid, c, orig) == -1L);

	/* find out the current (logical) location */
	if (orig == SEEK_CUR)
	{
		/* if we stay in the buffer, use this short cut */
		if (mdp->buffer <= mdp->bufptr+c && c <= mdp->bufcnt)
		{
			mdp->bufptr += c;
			mdp->bufcnt -= c;
			/* reset the EOF flag, just in case */
			mdp->flags &= ~_MDEOF;
			return (0);
		}

		posn = mdtell(mdp);
	}

	/* clear out the buffer.  write it out if necessary */
	mdflush(mdp);

	/* go to the current (logical) location */
	if (orig == SEEK_CUR)
		lseek(mdp->fid, posn, SEEK_SET);

	/* reset the EOF flag, since we are seeking somewhere */
	mdp->flags &= ~_MDEOF;

	/* seek to the new position */
	return(lseek(mdp->fid, c, orig) == -1L);
}
