/*
 * Created 1989 by greg yachuk.  Placed in the public domain.
 */

#include <stdio.h>
#include "mdiskio.h"

/*
 * mdread -	read `nitems' of `size' bytes into a buffer.
 *		return the number of items fully read.
 */
mdread(ptr, size, nitems, mdp)
char   *ptr;
int	size;
int	nitems;
MDFILE *mdp;
{
	int	len;			/* length to transfer */
	long	lsize;			/* size left to read */

	lsize = nitems * size;		/* total size to read */

	while (lsize > 0)
	{
		/* force a new read, and save the character */
		mdungetc(mdgetc(mdp), mdp);

		/* don't take more than is in the buffer */
		len = (lsize < mdp->bufcnt) ? lsize : mdp->bufcnt;
		memcpy(ptr, mdp->bufptr, len);

		/* adjust all the counts */
		lsize -= len;
		ptr += len;
		mdp->bufptr += len;
		mdp->bufcnt -= len;

		/* if nothing left in the file, report the num of items read */
		if (mdeof(mdp))
			return (nitems - (lsize / size));
	}

	/* all of them got read */
	return (nitems);
}
