/*
 * Created 1989 by greg yachuk.  Placed in the public domain.
 */

#include <stdio.h>
#include "mdiskio.h"

/*
 * mdwrite -	write `nitems' of `size' bytes from a buffer to a file.
 *		return the number of items completely written.
 */
mdwrite(ptr, size, nitems, mdp)
char   *ptr;
int	size;
int	nitems;
MDFILE *mdp;
{
	int	len;			/* number of bytes to transfer */
	long	lsize;			/* size left to transfer */

	lsize = nitems * size;		/* total transfer size */

	while (lsize > 0)
	{
		/* force a flush, if necessary */
		mdputc(0, mdp);
		if (mdeof(mdp))
			return (nitems - (lsize / size));
		--mdp->bufptr;
		++mdp->bufcnt;

		/* don't put more in the buffer than it can hold */
		len = (lsize < mdp->bufcnt) ? lsize : mdp->bufcnt;
		memcpy(mdp->bufptr, ptr, len);

		/* adjust all the counts */
		lsize -= len;
		ptr += len;
		mdp->bufptr += len;
		mdp->bufcnt -= len;
	}

	/* all items got written */
	return (nitems);
}
