/*
 * mdiskio.h
 *
 * definitions and declarations to manage files which span diskettes.
 *
 * March 1989	created by greg yachuk.  placed in the public domain.
 */

#ifndef	S_IREAD
#include <sys/types.h>
#include <sys/stat.h>
#endif

#ifndef	SEEK_SET			/* sometimes defined in stdio.h */
#define	SEEK_SET	0
#define	SEEK_CUR	1
#define	SEEK_END	2
#endif

struct mdiskbuf {
	char   *bufptr;			/* pointer to next position to fill */
	int	bufcnt;			/* number of bytes left to fill */
	char   *buffer;			/* buffer of data */
	char   *basename;		/* base name of the file */
	char   *filename;		/* constructed filename */
	int	seq;			/* next sequence number to be used */
	char	fid;			/* file id */
	char	spare;			/* in case we can't allocate a buffer */
	char	flags;			/* high level flags */
	int	oflag;			/* file creation flags */
	char *(*filenm)();		/* to construct new filename */
	int   (*ateof)();		/* at *final* EOF? */
	int   (*prompt)();		/* to prompt between diskettes */
};

#define	MDFILE	struct mdiskbuf
extern MDFILE _mdstdin;
extern MDFILE _mdstdout;
extern MDFILE _mdstderr;

#define	mdstdin		&_mdstdin
#define	mdstdout	&_mdstdout
#define	mdstderr	&_mdstderr

#define	_MDREAD		0x01
#define	_MDWRITE	0x02
#define	_MDRDWR		0x04
#define	_MDEMPTY	0x08

#define	_MDERR		0x10
#define	_MDEOF		0x20

#define	_MDPERMS	S_IREAD|S_IWRITE

#ifndef	MSDOS
#define	O_BINARY	0
#define	O_TEXT		0
#endif

#ifdef	BSD
#define	memmove(d,s,c)	bcopy((s),(d),(c))
#endif

#define	mdsetbase(d,n)	((d)->basename=(n))
#define	mdsetseq(d,n)	((d)->seq=(n))
#define	mdfnfilenm(d,f)	((d)->filenm=(f))
#define mdfnateof(d,f)	((d)->ateof=(f))
#define	mdfnprompt(d,f)	((d)->prompt=(f))

#define	mdfileno(d)	((d)->fid)
#define	mdseqno(d)	((d)->seq)

#define	mdeof(d)	((d)->flags & _MDEOF)
#define	mderror(d)	((d)->flags & _MDERR)
#define	mdclrerr(d)	((d)->flags &= ~_MDERR)

#define	mdputc(c,d)	(!(d)?(c):((--(d)->bufcnt>=0)?(int)(*(d)->bufptr++=(c))\
			 :_mdflush((c),(d))))
#define	mdgetc(d)	(--(d)->bufcnt>=0 ? 0xff & *(d)->bufptr++ : _mdfill(d))

#define	_mdopen(d)	((d)->fid = open(((d)->filenm)(d),(d)->oflag,_MDPERMS))
#define	_mdclose(d)	(close((d)->fid),(d)->fid=(-1))

#ifdef	__STDC__
MDFILE *mdopen(char *name,char *mode,char *(*fnfilenm)(),int seq);
int	mdclose(MDFILE *mdp);
int	mdflush(MDFILE *mdp);
long	mdtell(MDFILE *mdp);
long	mdseek(MDFILE *mdp,long c,int orig);
int	mdungetc(int c,MDFILE *mdp);
int	mdsetbuf(MDFILE *mdp, int blen);
int	mdread(char *ptr,int size,int nitems,MDFILE *mdp);
int	mdwrite(char *ptr,int size,int nitems,MDFILE *mdp);
int	mdateof(MDFILE *mdp,int mode);
int	mdalleof(MDFILE *mdp,int mode);
int	mdnoteof(MDFILE *mdp,int mode);
#else
MDFILE *mdopen();
int	mdclose();
int	mdflush();
long	mdtell();
long	mdseek();
int	mdungetc();
int	mdsetbuf();
int	mdread();
int	mdwrite();
int	mdateof();
int	mdalleof();
int	mdnoteof();
#endif
