/*
 * Created 1989 by greg yachuk.  Placed in the public domain.
 */

#include <stdio.h>
#include "mdiskio.h"

#ifdef	DOS
#define	BUFLIMIT	BUFSIZ
#else
#define	BUFLIMIT	1
#endif

#ifdef	CATCH_XFSZ
#include <signal.h>
#include <setjmp.h>
static jmp_buf _mdsigbuf;
#endif

/*
 * _mdflush -	flush an mdiskbuf out to the diskette.  write as many
 *		bytes as possible
 */
_mdflush(c, mdp)
int	c;
MDFILE *mdp;
{
	if (_mdflsbf(mdp) == EOF)
		return (EOF);
	return (mdputc(c, mdp));
}

/*
 * _mdflsbf -	do the actual work of flushing the buffer.
 */
_mdflsbf(mdp)
MDFILE *mdp;
{
	int	blen;		/* buffer length */
	int	ret;		/* return code */
	int	len;		/* length left to write out */
	int	cumm;		/* cummulative number of bytes written */

	mdp->bufcnt = 0;		/* in case we forget, below */

	if (mdp->flags & (_MDREAD|_MDERR))
	{
		mdp->flags |= _MDERR;	/* can't write to a read stream */
		return (EOF);
	}

	if (mdp->fid == -1)
		return (EOF);		/* got no business being here, anyway */

	/* record current buffer length */

	blen = mdp->bufptr - mdp->buffer;

	/* first flush when first char is `put', so allocate a buffer */

	if (mdp->buffer == NULL)
		blen = _mdgetbuf(mdp, blen);

	if (!(mdp->flags & _MDEMPTY))
	{
		cumm = 0;		/* nothing written yet */
		for(;;)
		{
			len = blen - cumm;
			/*
			 * try to write the whole buffer.  if it fails,
			 * try half as many, until we cannot fit any more
			 * on the disk (len < BUFSIZE) or we've written
			 * them all.
			 */
			do {
#ifdef	CATCH_XFSZ
				ret = -1;
				if (setjmp(_mdsigbuf) == 0)
				{
					_mdsetsig(1);
#endif
					ret = write(mdp->fid,
						    &mdp->buffer[cumm],
						    len);
#ifdef	CATCH_XFSZ
				}
				_mdsetsig(0);
#endif
				len >>= 1;
#ifndef	NODEBUG
				if (ret == -1)
					perror(mdp->basename);
#endif
				if (ret != -1)
					cumm += ret;	/* cumulative total */
			} while (len >= BUFLIMIT && cumm < blen);

			if (cumm >= blen)
				break;		/* wrote them all */

			/* ran out of room on this diskette.  try next one */

			if (mdp->ateof(mdp, _MDWRITE))
				return (EOF);
			_mdclose(mdp);
			if (!mdp->prompt(mdp))
				return (EOF);
			if (_mdopen(mdp) == -1)
				return (EOF);
		}
	}

	/* reset to empty buffer */

	mdp->bufcnt = blen;
	mdp->bufptr = mdp->buffer;

	mdp->flags |= _MDWRITE;
	mdp->flags &= ~_MDEMPTY;

	return (0);
}

#ifdef	CATCH_XFSZ
_mdsighdlr()
{
	signal(SIGXFSZ, _mdsighdlr);
	longjmp(_mdsigbuf, 1);
}

_mdsetsig(set)
int	set;
{
	static int (*old_sighdlr)();

	old_sighdlr = signal(SIGXFSZ, (set)? _mdsighdlr : old_sighdlr);
}
#endif
