/*
 * Created 1989 by greg yachuk.  Placed in the public domain.
 */

#include <stdio.h>
#include <malloc.h>
#include "mdiskio.h"

/*
 * _mdfill -	fill an mdiskbuf from the diskette.  read as many
 *		bytes as possible
 */
_mdfill(mdp)
MDFILE *mdp;
{
	int	blen;		/* length of buffer */
	int	len;		/* number of chars yet to read */
	int	cumm;		/* total number of chars read so far */
	int	ret;		/* number of chars most recently read */

	mdp->bufcnt = 0;		/* in case we forget, later */

	if (mdp->flags & (_MDERR|_MDWRITE))
	{
		mdp->flags |= _MDERR;	/* can't read into a write stream */
		return (EOF);
	}

	if (mdeof(mdp))
		return (EOF);		/* go no business even being here */

	/* calculate the size of the buffer */

	blen = mdp->bufptr - mdp->buffer;

	/* first fill when `get' first char, so allocate buffer */

	if (mdp->buffer == NULL)
		blen = _mdgetbuf(mdp, blen);

	/*
	 * try to read an entire buffer.  if the file ends, but
	 * continues on another disk, calculate the remaining number
	 * of bytes to fill the buffer, and try to read them in.
	 */
	for (cumm = 0; cumm < blen; cumm += ret)
	{
		len = blen - cumm;	/* number remaining to be read */
		ret = read(mdp->fid, &mdp->buffer[cumm], len);
		if (ret == -1)
			return (EOF);	/* signal error right away */

		/*
		 * if we got some characters, check if we got enough.
		 * there might still be more to read, due to the way
		 * that microsoft does CR/LF translation.
		 */

		if (ret != 0)
			continue;

		/*
		 * didn't get any this read.  if we managed to get some
		 * off this file (diskette), just cut our losses.
		 */

		if (cumm != 0)
			break;

		/* otherwise, try the next diskette */

		if (mdp->ateof(mdp, _MDREAD))
		{
			/* real-final EOF, so don't close the file */
			mdp->flags |= _MDEOF;
			mdp->bufptr = mdp->buffer + blen;
			return (EOF);
		}

		_mdclose(mdp);
		mdp->prompt(mdp);
		if (_mdopen(mdp) == -1)
			break;		/* something went wrong */
	}

	mdp->bufptr = mdp->buffer + (blen - cumm);
	mdp->bufcnt = cumm;		/* record actual number of bytes */

	if (cumm < blen)
		memmove(mdp->bufptr, mdp->buffer, cumm);

	/* mark buffer as having a read done on it (in case of RDWR) */
	mdp->flags |= _MDREAD;
	mdp->flags &= ~_MDEMPTY;	/* no longer empty */
	return (mdgetc(mdp));
}
