/*
 * Created 1989 by greg yachuk.  Placed in the public domain.
 */

#include <stdio.h>
#include <fcntl.h>
#include "mdiskio.h"

/*
 * mdclose -	flush the buffer if writing, close the file and deallocate
 */
mdclose(mdp)
MDFILE *mdp;
{
	if (mdp->fid != -1)
	{
		mdflush(mdp);
		_mdclose(mdp);
	}

	if (mdp->buffer != NULL)
		free(mdp->buffer);

	free(mdp);
}

/*
 * mdflush -	flush the buffer for output, and clear for input
 */
mdflush(mdp)
MDFILE *mdp;
{
	int	bufsiz;

	/* return zero if we have not allocated a buffer, yet */
	if (mdp->buffer == NULL)
		return (0);

	/* return zero if buffer is empty */
	if (mdp->flags & _MDEMPTY)
		return (0);

	/* return zero if file is read only */
	if (mdp->flags & _MDREAD)
		mdp->bufptr += mdp->bufcnt;
	else	/* _MDWRITE */
	{
		/* keep track of the current size of the buffer */
		bufsiz = mdp->bufcnt + (mdp->bufptr - mdp->buffer);

		/* flush the buffer */
		if (_mdflsbf(mdp) == EOF)
			return (EOF);

		/* set buffer ptr to end of buffer (not just chars written) */
		mdp->bufptr = mdp->buffer + bufsiz;
	}

	/* mark the buffer as empty */
	mdp->bufcnt = 0;
	mdp->flags |= _MDEMPTY;

	/* if open for read/write, reset the read and write flags */
	if (mdp->flags & _MDRDWR)
		mdp->flags &= ~(_MDREAD|_MDWRITE);

	return (0);
}
