
/*
 * mkxref - a program to list the titles from man pages
 *
 * All files in /usr/man/?_man/man? are searched for their title lines.
 * A title line is the first line following the ".SH NAME" line. Nroff
 * escapes are removed and the lines are written to the standard output.
 * If no title line is found in a file, the file's name is printed on
 * the standard error output.
 *
 * AUTHOR
 *	Edward C. Bennett, edward@ukecc.UUCP
 *
 * Copyright 1985 by Edward C. Bennett
 *
 * Permission is given to alter this code as needed to adapt it to forign
 * systems provided that this header is included and that the original
 * author's name is preserved.
 */
#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/dir.h>
#include <fcntl.h>
#include <string.h>

char	*mandirs[] = {
	"u_man/man1",
	"p_man/man2",
	"p_man/man3",
	"u_man/man6",
	"p_man/man4",
	"p_man/man5",
	"a_man/man1",
	"a_man/man7",
	"a_man/man8",
};
#define	NUMDIRS		sizeof(mandirs)/sizeof(char *)

main(argc, argv)
int argc;
char **argv;
{
	char	manbuf[BUFSIZ];
	int	fd, i, len;
	long	lseek();
	struct	direct	manent;

	chdir("/usr/man");

	for (i = 0; i < NUMDIRS; i++) {
		if ((fd = open(mandirs[i], O_RDONLY)) == -1)
			continue;

		/*
		 * Skip "." and ".."
		 */
		lseek(fd, 2*sizeof(manent), 0);
		while (read(fd, &manent, sizeof(manent)) == sizeof(manent)) {
			if (manent.d_ino == 0)
				continue;

			sprintf(manbuf, "%s/%s", mandirs[i], manent.d_name);
			Findname(manbuf);
		}
	}
}

Findname(manfile)
char *manfile;
{
	char	*p, line[BUFSIZ], section[4];
	int	i, flag = 0;
	FILE	*fp;

	strcpy(section, strchr(manfile, '.')+1);
	if ((fp = fopen(manfile, "r")) == NULL)
		return;

	while (fgets(line, BUFSIZ, fp) != NULL) {
		if (!strncmp(line, ".SH NAME", 8)) {
			flag++;
			if ((p = fgets(line, BUFSIZ, fp)) != NULL) {
				i = 0;
				while (*p) {
					/*
					 * Remove escapes
					 */
					if (*p == '\\') {
						if (*++p == 's') {
							if (*++p == '-' || *p == '+') {
								p++;
								i--;
							}
							p++;
							i -= 2;
						}
						else if (*p == '*') {
							p += 2;
							i -= 3;
						}
						else if (*p == '&') {
							p++;
							i -= 2;
						}
						else if (*p == '-') {
							printf("(%s) ", section, ")");
							for (i += (int)(p - line) + strlen(section); i < 25; i++)
								putchar(' ');
							putchar(*p++);
						}
						else
							putchar(*p++);
					}
					else
						putchar(*p++);
				}
			}
			break;
		}
	}
	if (!flag)
		fprintf(stderr, "%s\n", manfile);
	fclose(fp);

	return;
}
