/*
 * updateall - update the /usr/catman files
 *
 * All of the unformatted manual pages are checked against the copies
 * in the /usr/catman directory. If the unformatted copy is newer, a
 * new formatted and packed copy is placed in /usr/catman.
 *
 * AUTHOR
 *	Edward C. Bennett, edward@ukecc.UUCP
 *
 * Copyright 1985 by Edward C. Bennett
 *
 * Permission is given to alter this code as needed to adapt it to forign
 * systems provided that this header is included and that the original
 * author's name is preserved.
 */
#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/dir.h>
#include <string.h>

char	*mandirs[] = {
	"u_man/man1",
	"p_man/man2",
	"p_man/man3",
	"u_man/man6",
	"p_man/man4",
	"p_man/man5",
	"a_man/man1",
	"a_man/man7",
	"a_man/man8",
};
#define	NUMDIRS		sizeof(mandirs)/sizeof(char *)

main()
{
	char	manbuf[BUFSIZ], cmd[BUFSIZ], catbuf[BUFSIZ], catbufz[BUFSIZ];
	int	status;
	void	exit();
	struct	stat	manstat, catstat;
	int	fd, i;
	long	lseek();
	struct	direct	manent;

	chdir("/usr/man");

	for (i = 0; i < NUMDIRS; i++) {

		if ((fd = open(mandirs[i], O_RDONLY)) == -1)
			continue;

		lseek(fd, 2*sizeof(manent), 0);
		while (read(fd, &manent, sizeof(manent)) == sizeof(manent)) {
			if (manent.d_ino == 0)
				continue;

			sprintf(manbuf, "%s/%s", mandirs[i], manent.d_name);

			strcpy(catbuf, "/usr/catman/");
			strcat(catbuf, manbuf);
			strcpy(catbufz, catbuf);
			strcat(catbufz, ".z");

			stat(manbuf, &manstat);
			if (stat(catbufz, &catstat) == -1)
				catstat.st_mtime = -1;

			if (catstat.st_mtime < manstat.st_mtime) {
				unlink(catbufz);
				if (fork() == 0) {
					sprintf(cmd, "nroff -man %s > %s", manbuf, catbuf);
					execl("/bin/sh", "sh", "-c", cmd, 0);
				}
				wait(&status);
				if (fork() == 0) {
					sprintf(cmd, "pack -f %s", catbuf);
					execl("/bin/sh", "sh", "-c", cmd, 0);
				}
				wait(&status);
			}
		}
	}
}
