/*
Given a list of machine names, return the name of the machine in that list
with the lowest load average in /usr/spool/rwho.

Written by John DiMarco, March 1989 at the University of Toronto
Based on a program 'asun' by Jonathon Haruni.

 */

#include <stdio.h>
#include <string.h>

#define STREQ(a,b)(strcmp((a),(b)) == 0)
#define TRUE  1
#define FALSE 0

#define TOOBIGLOAD 30000

extern char *getenv();
extern char *optarg;
extern int opterr;

struct partofrwhodfile {
	char fill[4];
	int garbage[2];
	char hostname[32];
	int loadav;
};


main(argc, argv)
int argc;
char *argv[];
{
	FILE *fp, *input;
	int c, verbose, bestload = TOOBIGLOAD;
	char besthost[32];
	char thishost[80];
	char filename[120];
	struct partofrwhodfile entry;

	*besthost = '\0';

	verbose = FALSE;
	input = stdin;

	while((c = getopt(argc, argv, "vf:")) != EOF){
		switch(c){
		case 'v':
			/* Verbose mode: print out error messages for      */
			/* hostnames which don't appear in /usr/spool/rwho */
			verbose = TRUE;
			break;
		case 'f':
			/* Take input from a file rather than stdin */
			input = fopen(optarg, "r");
			if(NULL==input){
				(void)fprintf(stderr,
					      "%s: Can't open file %s \n",
					      argv[0], optarg);
				(void)exit(1);
			}
			break;
		case '?':
			(void)fprintf(stderr, "Usage: %s [-v] [-f filename]\n",
				      argv[0]);
			(void)exit(1);
			break;
		}

	}
	
	while(!feof(input)){
		(void)fscanf(input, "%80s ", thishost);
		(void)sprintf(filename,"/usr/spool/rwho/whod.%s",
			      thishost);
		if((fp = fopen(filename,"r")) != NULL) {
			(void)fread(&entry,sizeof(struct partofrwhodfile),
			      1,fp);
			(void)fclose(fp);
			if(entry.loadav < bestload) {
				(void)strcpy(besthost,thishost);
				bestload = entry.loadav;
			}
		} else {
			if(verbose){
				fprintf(stderr, "%s: %s not found\n", 
					argv[0], filename);
			}
		}
	}
	if(TOOBIGLOAD == bestload){
		(void)fprintf(stderr, "%s: No data for specified hosts\n", 
			      argv[0]);
		(void)exit(1);
	}
	(void)printf("%s\n",besthost);
	if(input!=stdin)
		(void)fclose(input);
}
