/* new.h -- dynamic memory allocation */

extern char *malloc(), *ealloc(), *realloc(), *erealloc(), *strdup();
extern int free();
extern void panic();

#ifndef NULL
#define NULL 0
#endif

#define	new(t, n)	((t *) ealloc((n) * sizeof (t)))
#define renew(t, p, n)	(((p) == NULL) \
				? new(t, n) \
				: ((t *) erealloc((char *) (p), (n) * sizeof (t))))
#define	delete(p)	(((p) == NULL) ? 0 : free(p))
