/* vax.l -- basic block counting driver for vaxen */

%{

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "bool.h"
#include "bb.h"

extern void panic();

bool newfunc = FALSE;		/* started new function? */

%}

%%

\.stab[dn]\n	{ stabd(); return; }
\.stabs\n	{ stabs(); return; }
\.word\n	{ word(); return; }
\.text\n	{ text = TRUE;  passline(); return; }
\.data\n	{ text = FALSE; passline(); return; }
\..*\n		{ passline(); return; }

nop\n		{ safe(); return; }
movpsl\n	{ safe(); return; }
adwc\n		{ safe(); return; }

[as]ob.+\n	{ branch(); return; }
case[lwb]\n	{ branch(); return; }

bi[sc]psw\n	{ safe(); return; }
bi.+\n		{ inst(); return; }
b.+\n		{ safe(); return; }

jsb\n		{ inst(); return; }
jbr\n		{ jbr(); return; }
j.+\n		{ branch(); return; }
.+\n		{ inst(); return; }
\n		{ panic("null opcode"); }

%%

/* ARGSUSED */
bool labelstartsblock(s)
	char *s;
{
	return TRUE;
}

increment()
{
	if (instructions >= 0)
		fprintf(map, "%d %d\n", reached, instructions);
	instructions = 0;
	fprintf(out, "	incl	bb+%d\n", 4 * block++);
	fprintf(map, "%s %d ", filename, lineno);
	newblock = FALSE;
}

safeincrement()
{
	fputs("	movpsl	-(sp)\n", out);
	increment();
	fputs("	movw	(sp)+, (sp)\n	bicpsw	$0xf\n	bispsw	(sp)+\n", out);
}

jbr()
{
	if (text && newfunc) {
		funcprologue();
		newfunc = FALSE;
		increment();
		instructions++;
		reached = lineno;
		newblock = TRUE;
		passline();
	} else
		branch();
}

funcprologue()
{
	function(label, block);
	fprintf(out, "	tstl	bb_init\n	jneq	bb_%s\n", label);
	fprintf(out, "	calls	$0, bb_init_func\nbb_%s:\n", label);
}

word()
{
	if (text && newblock && label[0] == '_')
		newfunc = TRUE;
	passline();
}

epilogue(mapfile)
	char *mapfile;
{
	if (instructions >= 0)
		fprintf(map, "%d %d\n", reached, instructions);
	if (text)
		fprintf(out, "	.data\n");
	fprintf(out, "	.lcomm bb, %d\n", 4 * block);
	fprintf(out, "bb_mapfile:\n");
	fprintf(out, "	.asciz	\"%s\"\n", mapfile);
	fprintf(out, "bb_init:\n");
	fprintf(out, "	.long	0\n");
	fprintf(out, "bb_entry:\n");
	fprintf(out, "	.long	0\n");			/* next */
	fprintf(out, "	.long	%d\n", block);		/* len */
	fprintf(out, "	.long	bb\n");			/* count */
	fprintf(out, "	.long	bb_mapfile\n");		/* mapfile */
	fprintf(out, "	.text\n");
	fprintf(out, "bb_init_func:\n");
	fprintf(out, "	.word	0\n");
	fprintf(out, "	movl	__bblist, bb_entry\n");
	fprintf(out, "	movl	$bb_entry, __bblist\n");
	fprintf(out, "	incl	bb_init\n");
	fprintf(out, "	ret\n");
}
