/* ealloc.c -- error checking malloc */

#include <stdio.h>
#include "new.h"

extern char *progname;

/* VARARGS1 */  /* PRINTFLIKE0 */
void panic(fmt, a, b, c, d, e, f, g, h)
	char *fmt;
{
	fprintf(stderr, "%s: ", progname);
	fprintf(stderr, fmt, a, b, c, d, e, f, g, h);
	exit(1);
}

char *ealloc(n)
	int n;
{
	char *p = malloc(n);
	if (p == NULL)
		panic("malloc(%d) returned 0\n", n);
	return p;
}

char *erealloc(p, n)
	char *p;
	int n;
{
	p = realloc(p, n);
	if (p == NULL)
		panic("realloc(%d) returned 0\n", n);
	return p;
}

#include <string.h>

char *strdup(s)
	char *s;
{
	return strcpy(ealloc(strlen(s) + 1), s);
}
