/* bbexit.c -- exit routine for basic block counting */

#include <stdio.h>

typedef struct Entry Entry;
struct Entry {
	Entry	*next;
	int	len, *counts;
	char	*mapfile;
};

Entry *_bblist = NULL;
extern char *_bbfile;

extern char *malloc();

_bbdump()
{
	Entry *e;
	FILE *fp = fopen(_bbfile, "a");
	if (fp == NULL) {
		fprintf(stderr, "couldn't open %s\n", _bbfile);
		return;
	}
	for (e = _bblist; e != NULL; e = e->next) {
		int i;
		fprintf(fp, "%s %d\n", e->mapfile, e->len);
		for (i = 0; i < e->len; i++) {
			fprintf(fp, "%d\n", e->counts[i]);
			e->counts[i] = 0;
		}
	}
	fclose(fp);
}

exit(status)
	int status;
{
	_bbdump();
	_cleanup();
	_exit(status);
}
