/* bb.h -- basic block counting definitions */

#define WORDSIZE	256
#define	NOPRINT		-1000

#define streq(s, t)	(strcmp((s), (t)) == 0)
#define	atoi(s)		strtol((s), (char *) NULL, 0)


extern	FILE *out;		/* generated .s file */
extern	FILE *map;		/* generated .sL file */

extern	int lineno;		/* original source line number */
extern	char filename[];	/* original source filename */

extern	char *yystring;		/* input to lex */
extern	char *tail;		/* tail of line (everything after opcode) */
extern	char line[];		/* input line */
extern	char label[];		/* most recent label */

extern	bool text;		/* in text segment? */
extern	bool newblock;		/* started new basic block? */
extern	int block;		/* current basic block number */
extern	int instructions;	/* counter of instructions */
extern	int reached;		/* last line reached in basic block */


extern	void inst();		/* normal instruction */
extern	void safe();		/* instruction that uses condition codes */
extern	void branch();		/* any flow of control */
extern	void stabd(), stabs();	/* debugger symbol table */
extern	void passline();	/* no-op */


extern	bool labelstartsblock();	/* supplied in $TARGET.l */


#ifdef	YYLERR		/* lex */

#undef	output
#undef	input
#undef	unput

#define	input()		(*yystring == '\0' ? 0 : *yystring++)
#define	unput(c)	(*--yystring = (c))
#define	output(c)	(c)	/* force evaluation */

#endif
