/* 68020.l -- basic block counting driver for motorola 68020s */

%{

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "bool.h"
#include "bb.h"

extern void panic();

%}

%%

\.stab[dn]\n		{ stabd(); return; }
\.stabs\n		{ stabs(); return; }
\.text\n		{ text = TRUE;  passline(); return; }
\.data\n		{ text = FALSE; passline(); return; }
\..*\n			{ passline(); return; }
\|.+\n			{ passline(); return; }

link\n			{ linkprologue(); return; }

movem.+\n		{ safe(); return; }
trap\n			{ safe(); return; }
pea\n			{ safe(); return; }
nop\n			{ safe(); return; }
[ans]bcd\n		{ safe(); return; }
(add|neg|sub)x\n	{ safe(); return; }
un.+\n			{ safe(); return; }
pack\n			{ safe(); return; }
rox[lr]\n		{ safe(); return; }

bchg\n			{ inst(); return; }
btst\n			{ inst(); return; }
bclr\n			{ inst(); return; }
bf.+\n			{ inst(); return; }
bs.+\n			{ inst(); return; }
b.+\n			{ branch(); return; }

jbsr\n			{ inst(); return; }
jsr\n			{ inst(); return; }
j.+\n			{ branch(); }

.+\n			{ inst(); return; }
\n			{ panic("null opcode"); }

%%

increment()
{
	if (instructions >= 0)
		fprintf(map, "%d %d\n", reached, instructions);
	instructions = 0;
	fprintf(out, "	addql	#1, bb+%d\n", 4 * block++);
	fprintf(map, "%s %d ", filename, lineno);
	newblock = FALSE;
}

safeincrement()
{
	fputs("	movw	cc, sp@-\n", out);
	increment();
	fputs("	movw	sp@+, cc\n", out);
}

linkprologue()
{
	if (text && label[0] == '_') {
		funcprologue();
		increment();
	}
	instructions++;
	reached = lineno;
	passline();
}

funcprologue()
{
	function(label, block);
	fprintf(out, "	tstl	bb_init\n	jne	Lbb_%s\n", label);
	fprintf(out, "	jbsr	bb_init_func\nLbb_%s:\n", label);
}

bool labelstartsblock(s)
	char *s;
{
	if (s[0] == 'L' && s[1] == 'L')		/* only used by stab */
		return FALSE;
	return TRUE;
}

epilogue(mapfile)
	char *mapfile;
{
	if (instructions >= 0)
		fprintf(map, "%d %d\n", reached, instructions);
	if (text)
		fprintf(out, "	.data\n");
	fprintf(out, "	.even\n");
	fprintf(out, "	.lcomm	bb, %d\n", 4 * block);
	fprintf(out, "bb_init:\n");
	fprintf(out, "	.long	0\n");
	fprintf(out, "bb_map:\n");
	fprintf(out, "	.asciz	\"%s\"\n", mapfile);
	fprintf(out, "	.even\n");
	fprintf(out, "bb_entry:\n");
	fprintf(out, "	.long	0\n");			/* next */
	fprintf(out, "	.long	%d\n", block);		/* len */
	fprintf(out, "	.long	bb\n");			/* count */
	fprintf(out, "	.long	bb_map\n");		/* mapfile */
	fprintf(out, "	.text\n");
	fprintf(out, "bb_init_func:\n");
	fprintf(out, "	movl	__bblist, sp@-\n");
	fprintf(out, "	movl	sp@+, bb_entry\n");
	fprintf(out, "	movl	#bb_entry, __bblist\n");
	fprintf(out, "	movl	#1, bb_init\n");
	fprintf(out, "	rts\n");
}
