/*
 * keydef() - easily / quickly redefine vt200, vt300 function keys
*/
static char Keydef[] = "@(#)keydef.c	1.5	4/11/89";  /* posted to USENET */
#include <stdio.h>
#include <pwd.h>
   struct passwd *pw;
#include "keydef.h"

/* string to program key      string to print to user  */
/*                    v          v                     */
char *Default[] = { "23/1B", "F11 is ESC",
                    "28/6170726f706f730a","HELP key is apropos",
                     NULL, NULL }; /* must be last in array */
/* Use the Default array for specifing local defaults that should be set */

void Getuser();
int debug = 0;
char *ProgKey();

main(argc, argv)
  int    argc;
  char **argv;
{
  int keynum;
  char fname[BUFSIZ], lfname[BUFSIZ], record[BUFSIZ];
  char *prog;
  char *p, **defaults = Default;

 if( 2 == 1 ) {
   /* The contents of this if() statement may not be changed   */
   printf(" (C) Copyright 1989 by Gordon P. Vickers, Sunnyvale, Ca.\n");
   printf("   { mips | pyramid | phillabs }!prls!gordon \n");
   printf("Distribution requiring payment in excess of reproduction\n");
   printf("cost requires authors written consent.\n");
   printf("Free distribution is encouraged if this notice remains intact\n");
/*     This program is offerred AS-IS, without warrenty of any kind.
           U S E   A T   Y O U R   O W N   R I S K
       I have nothing to gain from sharing this so I should have nothing
       to risk. 
*/  
 }

  strcat(fname,PROGNAME);
  argv++;     /* get past program name */
  while( *argv != NULL) {
     if (!IsDigit(*argv)) {
       if(!strcmp(*argv,"-d"))
         debug = 1;
       else
         strcat(fname, *argv);
     }
     else {
          Getuser(*argv);
          exit(0);
     }
   argv++;
  }

  /* find user's home directory so we can find the correct keydef file */
  if( (pw = getpwuid(getuid())) == NULL) {
      fprintf(stderr,"Can't figure out where your home directory is.\n");
      exit(0);
  }
  sprintf(lfname,"%s/.%s",pw->pw_dir,fname); /* complete filename */

  printf("Setting defaults:\n");
  while(*defaults != NULL) {  /* Must use two prints so pointer inc's OK */
  if(debug)
    printf("^[%s%s^[%c",PREFIX, *defaults++,BSLASH);
  else
    printf("%c%s%s%c%c",ESC,PREFIX, *defaults++,ESC,BSLASH);
  printf("\t%s\n", *defaults++);
  }

  if( (freopen(lfname,"r",stdin)) == NULL) {
     perror(lfname);
     exit(0);
  }
 
  printf("Settings from %s%s\n",RCFILE,*argv);

/* OK TO HERE */
  while ( (fgets(record,BUFSIZ,stdin)) != NULL ) {
    p = record;
    *(p + strlen(record) -1) = NULL; /* delete the newline,added in printf */
    if(*p == 'F' || *p == 'f')
      p++;              /* for compatibility with previous keydef versions */
    if(*p == '!') {     /* test for shell escape */
      p++;
      system(p);        /* the expensive way but isn't used often */
      continue;
    }
    if(!(keynum = GetKey(p)) )
        continue;
    prog = ProgKey(p,keynum);
    if(prog != NULL)
      printf("%s%s\n",prog,p); /* moved newline to here, personal preferance */
  }
} /* end of main */

void Getuser(s)
  char *s;
{
   int key;
   char *ip, record[BUFSIZ], input[BUFSIZ];

   strcpy(record,s);
   while(!(key = GetKey(record)) ) { 
     if(record[0] == 'e' || record[0] == 'q')
        exit(0);
     printf("\n    Sorry, that's not a valid function key number\n",key);
     printf("Valid responses are:\n");
     printf("    6     7     8     9     10\n");
     printf("   11 (esc)     12 (bs)     13 (lf)\n");
     printf("   14    15 (help)   16 (do)\n");
     printf("   17    18    19    20\n");
     printf("OR type any of: exit     e    quit     q\n");
     printf("\nEnter function key number : ");
     fgets(record,BUFSIZ,stdin);
   }
   printf("New definition : ");
   fgets(input,BUFSIZ,stdin);
   ip = input;
   while(*ip++ != NULL)
     if(*ip == '\n')    /* strip newline from user input string */
       *ip = NULL;
   strcat(record,input);
   printf("%s\n",ProgKey(record,key));
   exit(0);
}

/* IsDigit(s) - get function key number from string */
IsDigit(s)
  char *s;
{
  int digit = 0;
  if(*s <= '9' && *s >= '0') 
    sscanf(s,"%2d%*s",&digit);
 return(digit);
}

/* GetKey() */
GetKey(s)
 char *s;
{
  int key;

  key = IsDigit(s);
  switch (key) {
         case 6: case 7: case 8: case 9: case 10:
                 key += 11; break;
         case 11: case 12: case 13: case 14:
                 key += 12; break;
         case 15: case 16:
                 key += 13; break;
         case 17: case 18: case 19: case 20:
                 key += 14; break;
         default:
                 key = 0;
  }
  return(key);
} 

/*** ProgKey() ****/
char *
ProgKey(s,k)
  char *s;
  int k;
{
  char t[BUFSIZ], buf[4];

  if(debug)
    sprintf(t,"^[%s%d/",PREFIX,k); /* make preamble */
  else
    sprintf(t,"%c%s%d/",ESC,PREFIX,k); /* make preamble */

  if(*s >= '0' && *s <= '9') /* move past the key number */
     s++;
  if(*s >= '0' && *s <= '9') /* ...which may be two digits */
     s++;
  while( *s != NULL) {
     if(*s == '^'){ /* map a control charector */
        s++;
        sprintf(buf,"%02x", (int)(( *s - '@') > 0 ? *s - '@' : *s));
     }
     else if(*s == BSLASH){
        switch( *(s + 1) ) {
           case 'n' : sprintf(buf,"%02x",(int)'\n'); s++; break;
           case 'r' : sprintf(buf,"%02x",(int)'\r'); s++; break;
           case 't' : sprintf(buf,"%02x",(int)'\t'); s++; break;
           case BSLASH:sprintf(buf,"%02x",(int)'\\'); s++; break;
           case '^' :  sprintf(buf,"%02x",(int)'^'); s++; break;
           default: sprintf(buf,"%02x",(int)*s);
        }
     }
     else {
        sprintf(buf,"%02x",(int)*s);
     }
     strcat(t,buf);
     s++;
  } 
  if(debug)
    sprintf(buf,"^[\\");
  else
    sprintf(buf,"%c%c",ESC,BSLASH);

 strcat(t,buf);
 return(t);
}
