.TH KEYDEF local
.ds SI S\s-2IX\s+2\s-2ELS\s+2
.SH NAME
keydef - quickly / easily redefine VT2xx and VT3xx function keys.
.SH SYNTEX
keydef [n filename]
.SH DESCRIPTION
.I Keydef 
reads a file
in the user's home directory that contains definitions for the function keys.
If no file is specified then the file read is .keydef else the file read
is the concatenation of .keydef and the filename specified.
If unable to open a file,
certain site specific default setting will be made.
.PP
The definition file(s) consist of one definition per line.
Each line must start with a one or two digit function key number
followed by the ascii string to be programed.
If the string to be programmed begins with a digit,
then the function key number may require a leading zero to make it two
digits long.
.PP
Definition records may also contain the the two letter symbols \\r,\\t,\\n
\\\, and \\^ .
These will be mapped to; RETURN (013H), TAB (009H), NEWLINE
(010H), back-slash, and circumflex (AKA "carrot") respectfully.
.PP
Difinitions may also contain the "tame" representation of control charectors.
A two letter sequence begining with a circumflex is assumed to indicate
that a control charector is to be programmed.
In this case the value of 64 is subtracted from the next charector and
if the result is positive then it is substituted into the output string
in place of the two original charectors.
To program a literal circumflex, preceed it with a backslash.
.PP
If the first non-white charector of a record is not a digit then it is
assumed to be a comment and is ignored.
The only exception is if this charector is an exclamation mark.
Any line beginning with an exclimation mark is assumed to be a shell escape.
The remainder of the line is passed to a shell.
.PP
.I keydef
may also be given a numeric option on the command line.
If the numeric corresponds to a reprogrammable function key number
the user will be asked to supply a new definition for that key.
The program will then set just that one key and derminate.
.SH CHANGES
.PP
.I keydef
no longer writes to the 
.I keydefID
file of the user's home directory.
.PP 
Description files from previous versions are compatible with this version
but the user is cautioned that this version now maps certain key
combinations (\\r, \\t, and control charectors) that were not supported
before.
.PP
To use the programmed function keys simply depress the SHIFT key with
the desired funtion key.
.SH RESTRICTIONS
.I Keydef
only programs function keys 06-14, HELP, DO, and 17-20.
The author has made various attempts at programming other keys
but without success.
.PP
Labeling your keyboard becomes more difficult.
.PP
There is a finite amount of memory in the terminal for storing the
definitions .
.PP
The user may experiance dissapointing results in programming keys that
have long definitions or with keys that follow these.
I don't know the source of this problem, prehaps XON/XOFF are interfering.
The work-around is to find a strategic place(s) between definitions
for a shell escape to "sleep 1".
./" reproduce with: nroff -man
./" SCCSID @(#)keydef.L	1.4	4/11/89
.SH "EXAMPLE FILE"
.br
06cat ~/.keyids
.br
7source /usr/local/80col\n
.br
!echo shell escape worked.
.br
08 source /usr/local/132col\n
.br
09 keydef vi
.br
10 main(argc,argv)\n int    argc;\n char **argv;\n {\n
.br
example of a comment.
.br
11^[
.br
15 apropos
.SH "SEE ALSO"
VT220 or VT320 Programmer Pocket Guide.
.SH Author
Gordon Vickers {pyramid|mips|phillabs}!prls!gordon
.br
comments, suggestions, and patches welcomed.
