/*
 * Syntax: av[0] inc_file
 *
 * This programme uses the file inc_file to construct a second stage lex
 * analyser called keyword() in file keyword.c.
 */
#include <stdio.h>
#include <ctype.h>
#define NTOKEN 200		/* maximum number of tokens */
#define OUTFILE "keyword.c"	/* name of output file */
#define POUT fprintf(outfil	/* save space */
#define SIZE 40			/* maximum size of token */

static char token[NTOKEN][SIZE];

main(ac,av)
int ac;
char *av[];
{
   char  c;
   FILE  *infil,			/* file descriptor for *.h */
	 *outfil;
   int   i,
	 num_token;                    /* number of tokens */
   extern int *strcmp();

   if(ac < 2) {
      fprintf(stderr,"Syntax: make_keyword inc_file\n");
      exit(-2);
   }
   if((infil = fopen(av[1],"r")) == NULL) {
      fprintf(stderr,"Can't open %s\n",av[1]);
      exit(-2);
   }

   if((outfil = fopen(OUTFILE,"w")) == NULL) {
      fprintf(stderr,"Can't open %s\n",OUTFILE);
      fclose(infil);
      exit(-2);
   }
/*
 * Read in the tokens from av[1].
 * Use the val_tok field to give their value in each file
 */
   for(i = 0;i < NTOKEN;i++) {
      if(fscanf(infil,"%*s %*s %s %*d",token[i]) != 1) {
	 break;
      }
   }
   fclose(infil);
   num_token = i;

   qsort(token,num_token,SIZE,strcmp);       /* sort tokens */

   POUT,"/*\n");
   POUT," */\n");
   POUT,"#include <stdio.h>\n");
   POUT,"#include \"%s\"\n",av[1]);
   POUT,"\n");
   POUT,"extern int strcmp();\n");
   POUT,"\n");
   POUT,"keyword(word)\n");
   POUT,"char word[];		/* word to look for */\n");
   POUT,"{\n");
   POUT,"\n");
   POUT,"  switch (word[0]) {\n");
   for(i = 0,c = 'A';c <= 'Z' && i < num_token;c++) {    /* assumes ascii */
      POUT,"  case '%c' :\n",c);
      while(token[i][0] <= c && i < num_token) {
	 POUT,"      if(!strcmp(word,\"%s\")) {\n",token[i]);
	 POUT,"         return(%s);\n",token[i]);
	 POUT,"      } else\n");
	 i++;
      }
      POUT,"         break;\n");
   }

   POUT,"   default : break;\n");
   POUT,"   }\n");
   POUT,"   return(WORD);\n");
   POUT,"\n");
   POUT,"}\n");

   fclose(outfil);
#ifdef unix
   exit(0);			/* success */
#else
   exit(1);			/* success in vmsese */
#endif UniX
}
