#include <stdio.h>
#include "yaccun.h"
#include "keyword.h"
#include "jcl.h"

#define FORMAT "%[ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789@#$]"
						/* format for reading fields */
#define YYCHARVAL (yylval.charval)		/* an abbreviation */
char token[CHARMAX];				/* text of last token read */
static char card[83],				/* current card */
	    *cptr;
extern int verbose;				/* get debugging output */
static int need_card = 1;		/* Do I need to read a new card? */

int
yylex()
{
   static char word[50];			/* error message */
   int ret;

   if(need_card) {			/* so read one */
      if(fgets(&card[1],81,stdin) == NULL) {
	 return(ENDMARK);
      }
      need_card = 0;
      if(msglevel1 > 0) {
	 fputs(&card[1],msgout);
      }
      if(strlen(&card[1]) > 72) {
	 card[0] = card[72];		/* save continuation character */
      } else {
	 card[0] = ' ';			/* no continuation character */
      }
      card[72] = '\0';			/* delete end of card */
      cptr = &card[72];
      while(*--cptr == ' ') ;		/* find trailing blanks */
      *(cptr + 1) = '\0';		/* strip them */
      cptr = &card[1];			/* now find comments */
      while(*cptr++ != ' ') ;		/* skip //name field */
      while(*cptr++ == ' ') ;		/* and first blank field */
      while(*cptr++ != ' ') ;		/* and JOB/DD/EXEC/etc field */
      while(*cptr++ == ' ') ;		/* and second blank field */
      while(*cptr++ != ' ') ;		/* and options field */
      *--cptr = '\0';			/* cut the comment off the card */
      cptr = card + strlen(card);	/* 1 past last character */
      if(*(cptr - 1) != '\n') {		/* check if card ends in \n */
	 *cptr++ = '\n';
	 *cptr = '\0';
      }
      cptr = &card[1];
   }

   if(*cptr == '\0') {
      need_card = 1;
      return(yylex());
   }

   if(cptr == &card[1]) {
      if(!strncmp(cptr,"//*",3)) {			/* comment */
	 need_card = 1;
	 return(yylex());
      } else if(!strncmp(cptr,"//",2)) {		/* May be EXEC */
	 cptr += 2;					/* skip // */
	 if(sscanf(cptr,FORMAT,word) == 1) {		/* read NAME field */
	    cptr += strlen(word);
	 } else if(*cptr == '\n') {			/* null card */
	    sprintf(token,"//\\n");
	    return(NULL_CARD);
	 } else {
	    word[0] = '\0';
	 }
	 if(yylex() == ' ') {				/* EXEC or null? */
	    if((ret = yylex()) == EXEC) {		/* yes, an EXEC card */
	       strcpy(YYCHARVAL,word);
	       sprintf(token,"//%s EXEC",word);
	       return(ret);
	    } else if(ret == '\n') {			/* null card */
	       sprintf(token,"//\\n");
	       return(NULL_CARD);
	    }
	 }
	 cptr = &card[3];			/* no, rewind and return // */
	 sprintf(token,"//");
	 ret = DSLASH;
      } else if(!strncmp(cptr,"/*",2)) {
	 sprintf(token,"/*");
	 cptr += 2;
	 ret = SLASHSTAR;
      } else {
	 sprintf(word,"Card begins %c%c",*cptr,*(cptr+1));
	 yyerror(word);
	 sprintf(YYCHARVAL,"%c%c",*cptr++,*cptr++);
	 strcpy(token,YYCHARVAL);
	 ret = WORD;
      }
   } else {
      if(sscanf(cptr,FORMAT,YYCHARVAL) == 1) {
	 strcpy(token,YYCHARVAL);
	 cptr += strlen(YYCHARVAL);
	 ret = keyword(YYCHARVAL);
      } else {
	 switch (*cptr) {
	 case ',': case '.': case '/': case '\'': case '(': case ')':
	 case '*': case '&': case '+': case '-':  case '=':
	    sprintf(token,"%c",*cptr);
	    ret = *cptr++;
	    break;
	 case ' ':
	    while(*cptr == ' ') {
	       cptr++;
	    }
	    sprintf(token,"' '");
	    ret = ' ';
	    break;
	 case '\n':
	    if(card[0] != ' ' || *(cptr - 1) == ',') {	/* Continuation */
	       need_card = 1;				/* skip newline */
	       if(yylex() != DSLASH ||			/* card starts // */
				      yylex() != ' ') {	/* then spaces */
		  sprintf(word,"Expected continuation card");
		  yyerror(word);
	       }
	       return(yylex());				/* return next */
	    } else {
	       sprintf(token,"\\n");
	       cptr++;
	       ret = '\n';
	    }
	    break;
	 default:
	    sscanf(cptr,"%[^,./'()*&+-= ]",YYCHARVAL);
	    if(YYCHARVAL[strlen(YYCHARVAL) - 1] == '\n') {
	       YYCHARVAL[strlen(YYCHARVAL) - 1] = '\0';
	    }
	    strcpy(token,YYCHARVAL);
	    cptr += strlen(YYCHARVAL);
	    sprintf(word,"Illegal character in string \"%s\"",YYCHARVAL);
	    yyerror(word);
	    ret = WORD;
	    break;
	 }
      }
   }
   if(verbose) {
      fprintf(msgout,"TOKEN %s\n",token);
   }
   return(ret);
}

get_cchar()		/* get next character off a card */
{
   if(*cptr == '\n') {		/* at end of card */
      return('\n');
   } else {
      return(*cptr++);
   }
}

put_cchar(c)
int c;
{
   if(cptr > &card[0]) {
      *--cptr = c;
   }
}
