%{
#include <stdio.h>
#include "yaccun.h"
#include "jcl.h"
/*
 * declare variables in jcl.h
 */
char parm[PSIZE];			/* parameters on EXEC card */
FILE *msgout=stderr;			/* destination for output */
int disp[3],				/* 3 DISP parameters */
    msglevel1 = 1,msglevel2 = 1;	/* MSGLEVEL=(msglevel1,msglevel2) */

static char msg[50],			/* used for composing error messages */
	    step_name[40];		/* name of current step */
extern char token[];			/* text of last token read */
int pgm;				/* true if current step is a PGM */
extern int verbose;
%}

%start deck				/* the complete deck of cards */

%token <charval>
      EXEC WORD

%token					/* special characters */
      '\n' ',' '.' '/' '\'' '(' ')' '*' '&' '+' '-' '=' ' '
%token					/* control words */
      DD DSLASH ENDMARK JOB NULL_CARD SLASHSTAR
%token					/* keywords */
      COND					/* Misc. */
      MSGCLASS MSGLEVEL				/* JOB */
      PGM PROC PARM				/* EXEC */
      DATA DCB DISP DSN DUMMY UNIT		/* DD */

%type <charval>
      apost_word			/* string enclosed in ' ' */
      dd_file				/* name of file for DD statement */
      dot_name				/* name including '.'s */
      exec_card				/* PGM/PROC run by exec step */
      opt_dot_name			/* optional dot_name */
      opt_word				/* optional word */
      pgm_or_proc			/* name of PGM/PROC */

%type <intval>
      disp_par				/* DISP parameter */
      opt_disp				/* optional disp_par */
%%					/* start of rules */

deck  : job_card steps null_card
      {
	 job_clean_dd();		/* delete unwanted datasets */
	 return(0);
      }
      ;

steps : 				/* a collection of job steps */
      | steps step
      ;

step  : exec_card opt_dd_cards
      {
	 char command[200],
	      *define_dd();

	 if(pgm) {
	    sprintf(command,"%s%s %s",define_dd(step_name),$1,parm);
	    if(verbose) printf("%s\n",command);
	    system(command);
	 } else {
	    printf("Step %s runs proc %s\n",step_name,$1);
	    printf("Parameters: %s\n",parm);
	 }
	 step_clean_dd(step_name);
      }
      | error '\n'
      {
         yyerrok;
         yyclearin;
      }
      ;

opt_dd_cards :
      | opt_dd_cards dd_card
      ;

dd_card : DSLASH opt_dot_name ' ' DD ' ' dd_file '\n'
      { create_dd($2,$6,step_name,disp); }
      ;

dd_file	: '*'
      {
	 char line[81],
	      *mktemp(),
	      *tempname;
	 FILE *fil;

	 if((tempname = mktemp("DATXXXXXX")) == NULL) {
	    yyerror("Can't create temporary file name");
	    break;
	 }
	 if((fil = fopen(tempname,"w")) == NULL) {
	    sprintf(msg,"Can't open %s",tempname);
	    break;
	 }
	 strcpy($$,tempname);

	 while(fgets(line,81,stdin) != NULL) {
	    if(!strncmp("/*\n",line,3) || !strncmp("/* ",line,3)) {
	       break;
	    }
	    fputs(line,fil);
	 }
	 fclose(fil);

	 disp[0] = NEW;
	 disp[1] = DELETE;
	 disp[2] = DELETE;
      }
      | DUMMY dd_opts
	 { strcpy($$,"/dev/null"); }
      | DSN '=' dot_name dd_opts
	 { strcpy($$,$3); }
      ;

dd_opts	:
      {
	 disp[0] = UNKNOWN;
	 disp[1] = UNKNOWN;
	 disp[2] = UNKNOWN;
      }
      | dd_opts ',' DCB '=' WORD
      | dd_opts ',' DISP '=' disp_par
      {
	 disp[0] = $5;
	 disp[1] = UNKNOWN;
	 disp[2] = UNKNOWN;
      }
      | dd_opts ',' DISP '=' '(' opt_disp ',' opt_disp ')'
      {
	 disp[0] = $6;
	 disp[1] = $8;
	 disp[2] = UNKNOWN;
      }
      | dd_opts ',' DISP '=' '(' opt_disp ',' opt_disp ',' opt_disp ')'
      {
	 disp[0] = $6;
	 disp[1] = $8;
	 disp[2] = $10;
      }
      ;

disp_par : WORD
      {
	 if(!strcmp($1,"DELETE")) $$ = DELETE;
	 else if(!strcmp($1,"KEEP")) $$ = KEEP;
	 else if(!strcmp($1,"NEW")) $$ = NEW;
	 else if(!strcmp($1,"OLD")) $$ = OLD;
	 else {
	    sprintf(msg,"Unknown DISP parameter %s",$1);
	    $$ = UNKNOWN;
	 }
      }
      ;

opt_disp :
      { $$ = UNKNOWN; }
      | disp_par
      { $$ = $1; }
      ;

exec_card : EXEC ' ' pgm_or_proc exec_opts '\n'
      {
	 strcpy($$,$3);
	 strcpy(step_name,$1);
      }
      ;

exec_opts :
      | exec_opts ',' COND '=' '(' WORD ',' WORD ',' WORD ')'
      | exec_opts ',' PARM '=' apost_word
	 { strcpy(parm,$5); }
      | exec_opts ',' PARM '=' WORD
	 { strcpy(parm,$5); }
      ;

apost_word : '\'' /* [^']' */
      {
	 int i;

	 for(i = 0;i < CHARMAX
		&& ($$[i] = get_cchar()) != '\'' && $$[i] != '\n';i++) ;
	 if($$[i] != '\'') put_cchar($$[i]);
	 $$[i] = '\0';
      }
      ;

pgm_or_proc : PGM '=' WORD
      {
	 pgm = 1;			/* it's a programme */
	 strcpy($$,$3);
      }
      | PGM '=' apost_word
      {
	 pgm = 1;			/* it's a programme */
	 strcpy($$,$3);
      }
      | PROC '=' WORD
      {
	 pgm = 0;			/* it's a procedure */
	 strcpy($$,$3);
      }
      ;

job_card : DSLASH opt_word ' ' JOB ' ' dot_name job_opts '\n'
      ;

job_opts :
      | job_opts ',' MSGCLASS '=' WORD
      {
         if($5[0] == 'A') {
            if(msgout != stderr) fclose(msgout);
            msgout = stderr;
         } else if($5[0] == 'B') {
            if(msgout != stderr) fclose(msgout);
            if((msgout = fopen("JCL.out","w")) == NULL) {
	       yyerror("Can't open JCL.out");
	       msgout = stderr;
            }
         } else {
            sprintf(msg,"Unknown MSGCLASS %s",$5);
            yyerror(msg);
         }
      }
      | job_opts ',' MSGLEVEL '=' '(' WORD ',' WORD ')'
      {
         msglevel1 = atoi($6);
         msglevel2 = atoi($8);
      }
      ;

dot_name : WORD
         { strcpy($$,$1); }
      | dot_name '.' WORD
         { sprintf($$,"%s.%s",$1,$3); }
      ;

null_card : NULL_CARD
      | ENDMARK
      ;

opt_word : WORD
         { sprintf($$,$1); }
      |
         { sprintf($$,""); }
      ;

opt_dot_name : dot_name
         { sprintf($$,$1); }
      |
         { sprintf($$,""); }
      ;

opt_lparen :
      | '('
      ;

opt_rparen :
      | ')'
      ;
%%
yyerror(s)
char *s;
{
   if(!strcmp(s,"syntax error")) {
      fprintf(stderr,"Syntax error, last token read %s\n",token);
   } else {
      fprintf(stderr,"   %s\n",s);
   }
}
