/*
 * Maintain information about DD statements
 */
#include <stdio.h>
#include "jcl.h"

#define NDD 20				/* Max. number of current DD sets */
#define SIZE 80				/* length of character strings */

typedef struct {
   char name[SIZE],			/* name of DD set */
	file[SIZE],			/* name of associated file */
	step[SIZE];			/* name of step */
   int disp[3];				/* DISP modes */
} DD_SET;

static DD_SET dds[NDD];			/* the available DDs */

init_dd()
{
   int i;

   for(i = 0;i < NDD;i++) {
      dds[i].name[0] = '\0';
   }
}

create_dd(name,file,step,disp)
char *name,
     *file,
     *step;
int disp[];
{
   char msg[40];
   int i;

   for(i = 0;i < NDD;i++) {
      if(!strcmp(name,dds[i].name)) {
	 sprintf(msg,"DD set %s already exists",name);
	 yyerror(msg);
	 break;
      } else if(dds[i].name[0] == '\0') {
	 break;
      }
   }
   if(i == NDD) {
      yyerror("Too many DD sets");
      return(-1);
   }

   strcpy(dds[i].name,name);
   strcpy(dds[i].file,file);
   strcpy(dds[i].step,step);

   if(disp[0] != UNKNOWN) {
      dds[i].disp[0] = disp[0];
   } else {
      if(access(file,0) == -1) {		/* file dosn't exist */
	 dds[i].disp[0] = NEW;
      } else {
	 dds[i].disp[0] = OLD;
      }
   }

   if(disp[1] != UNKNOWN) {
      dds[i].disp[1] = disp[1];
   } else {
      if(dds[i].disp[0] == NEW) {
	 dds[i].disp[1] = DELETE;
      } else {
	 dds[i].disp[1] = KEEP;
      }
   }

   if(disp[2] != UNKNOWN) {
      dds[i].disp[2] = disp[2];
   } else {
      if(dds[i].disp[0] == NEW) {
	 dds[i].disp[2] = DELETE;
      } else {
	 dds[i].disp[2] = KEEP;
      }
   }
}

/******************************************************/
/*
 * Cleanup after a job step
 */
step_clean_dd(step)
char *step;				/* name of step */
{
   int i;

   for(i = 0;i < NDD;i++) {
      if(dds[i].name[0] != '\0' && !strcmp(step,dds[i].step)) {
	 if(dds[i].disp[1] == DELETE) {
	    unlink(dds[i].file);
	 }
      }
   }
}

/******************************************************/
/*
 * Cleanup after job terminates
 */
job_clean_dd()
{
   int i;

   for(i = 0;i < NDD;i++) {
      if(dds[i].name[0] != '\0') {
	 if(dds[i].disp[2] == DELETE) {
	    unlink(dds[i].file);
	 }
      }
   }
}

/******************************************************/
/*
 * Return a string defining all units used in a job step
 */
char *
define_dd(step)
char *step;				/* name of step */
{
   static char string[200],
	       *sptr;
   int i;

   sptr = string;
   for(i = 0;i < NDD;i++) {
      if(dds[i].name[0] != '\0' && !strcmp(step,dds[i].step)) {
	 sprintf(sptr,"%s=%s;export %s;",dds[i].name,dds[i].file,dds[i].name);
	 sptr += 10 + 2*strlen(dds[i].name) + strlen(dds[i].file);
      }
   }
   return(string);
}

