/******************************************************************************
*
*   Copyright P.J.Ruczynski 1990
*   This software is free for redistribution and re-use as long as this
*   copyright is included in all source files. This software is supplied
*   as is and no responsibilty is taken by the author for any problems
*   arising from this code.
*
* File name		-  hexprint.h
*
* Module name		-  HEXPRINT
*
* Author		-  P.J.Ruczynski	<pjr@pyra.co.uk>
*
* First Release		-  16 Feb 1990
*
* Version number	-  1.1
*
* Description		-  This file contains definitions required by the 
*			   hexprint routine.
*
*			Revision List
*
* pjr	02.08.89	Changed the bcopy and bcmp routines to use defines defined
*			in hexprint.h and controlled by compilation flag 'ATT'. With this
*			defined att routines are used, default means bsd routines are used.
*			Note that the compression stuff uses BCMP and BCOPY.
*
******************************************************************************/

#define	TRUE		1
#define	FALSE		0
#define	H_SLEN		16

#ifdef ATT
#define BCMP memcmp
#define BCOPY(a,b,c) memcpy(b,a,c)
#else /* ucb */
#define BCMP bcmp
#define BCOPY bcopy
#endif
