


    HEXCALC(1)                                                    HEXCALC(1)



    NAME
        hexcalc - interactive hexadecimal calculator

    SYNOPSIS
        hexcalc

    DESCRIPTION
        Hexcalc reads standard input for a sequence of expressions and
        commands. Expressions are evaluated and the result is output in
        the default radix on standard output. Commands are executed,
        producing their defined action.

        Expressions are made up of the following operands and operators:

        Operands:       Numeric literals; in the default radix, must begin
                        with a digit (for example, 0cc01e).

                        Variables; initialized with an assignment operation,
                        31 significant chars max.

                        Built-in functions:
                        name            description
                        ---------       -----------
                        DEC(expr)       output decimal value of expr
                        OCT(expr)       output octal value of expr
                        HEX(expr)       output hex value of expr

        Operators (highest to lowest precedence):
                        operator        description
                        --------        -----------
                        (  )            grouping
                        **              exponentiation
                        -  ~            unary minus, bitwise not
                        *  /  %         multiplication, division, modulus
                        +  -            addition, subtraction
                        <<  >>          left-shift, right-shift
                        &               bitwise and
                        ^               bitwise exclusive-or
                        |               bitwise or
                        =               assignment

        The following commands are supported:
                        name            description
                        ----------      -----------
                        help  HELP      print a help message
                        quit  exit      terminate execution
                        hex dec oct     set the default radix

        If assignment is the last operation performed when evaluating an
        expression, nothing is output.





                                     [ 1 ]


    HEXCALC(1)                                                    HEXCALC(1)



        Hexcalc also recognizes and ignores comments. Comments begin with
        either a '#' character or a '##' character pair and are terminated
        by a newline. Comments beginning with a single '#' are called non-
        echoing and are completely ignored. Comments beginning with a '##'
        pair are called echoing comments and are output to stdout, beginning
        with the second '#', without modification. While comments make
        little sense when using hexcalc interactively, they can be used in
        files that are fed to stdin to good effect.

        The _rationale_ behind the current built-in functions is to allow
        the capture of intermediate results in the output stream as well as
        modifying the default radix for the results of expression
        evaluation. Note that they are functions which return the input
        value as a result so they can be used as operands in more complex
        expressions.

        The initial default radix is hexadecimal.

    NOTES
        Hexcalc is based on hoc3, a calculator program that can be found in
        _The Unix Programming Environment_ by Brian W. Kernighan and Rob
        Pike, chapter 8. The entire chapter is an exposition of a method of
        organizing a software development project which develops six
        different, and successively more complex, versions of hoc, a
        calculator program. It also serves as an excellent introduction to
        and tutorial for yacc(1).

    AUTHOR
        Richard Hargrove
        25 June 1988


























                                     [ 2 ]
