/* C:/BIN\YACC.EXE -d hexcalc.y */
#line 1 "hexcalc.y"

#include "hexcalc.h"
typedef union {
  BASE_TYPE val;	/* actual value */
  Symbol *sym;		/* symbol table pointer */
} YYSTYPE;
#define NUMBER	257
#define CONST	258
#define VAR	259
#define BLTIN	260
#define UNDEF	261
#define QUIT	262
#define HELP	263
#define CHRADIX	264
#define LSH	265
#define RSH	266
#define UNARYMINUS	267
#define POW	268
extern int yychar, yyerrflag;
extern YYSTYPE yyval, yylval;
#line 81
#include <stdio.h>
#include <setjmp.h>

char *progname;		/* for error messages */
int lineno = 1;
int radix = 16;

STATIC char *credit =
"hexcalc 1.1 by Richard Hargrove, 25 June 1988; based on hoc3 from Kernighan and Pike";

jmp_buf prog_begin, prog_end;

/******************************************************************************/

void puthelp()
{
	static char *help_text[] = {
	"Type in an expression or command. Expressions other than assignment",
	"cause the evaluated result to be output. All values are 32-bit integers.",
	"Expressions are made up of the following operands and operators:",
	"",
	"Operands: numeric literals (must begin with a digit), variables",
	"(31 chars max, initialized with assignment), and built-in functions.",
	"Built-ins:	DEC(expr)	output decimal value of expr",
	"		OCT(expr)	output octal value of expr",
	"		HEX(expr)	output hex value of expr",
	"Operators:	(  )		grouping",
	"		**		exponentiation",
	"		-  ~		unary minus, bitwise not",
	"		*  /  %		multiplication, division, modulus",
	"		+  -		addition, subtraction",
	"		<<  >>		left-shift, right-shift",
	"		&		bitwise and",
	"		^		bitwise exclusive-or",
	"		|		bitwise or",
	"		=		assignment",
	"",
	"Commands:	help  HELP	print this message",
	"		quit  exit	terminate execution",
	"		hex dec oct	set the default radix",
	(char *)0
	};
	int i = 0;

	while (help_text[i] != (char *)0)
	{
	  puts(help_text[i++]);
	}
}

/******************************************************************************/

void warning (s, t)	/* print warning message */
char *s, *t;
{
	fprintf (stderr, "%s : %s", progname, s);
	if (t != (char *)0)
	{
		fprintf (stderr, " %s", t);
	}
	fprintf (stderr, " near line %d\n", lineno);
}


/******************************************************************************/

void yyerror (s)	/* called for yacc syntax error */
char *s;
{
	warning (s, (char *)0);
}

/******************************************************************************/

void execerror (s, t)
char *s, *t;
{
	warning (s, t);
	longjmp (prog_begin, 1);
}

/******************************************************************************/

main (argc, argv)
int argc;
char *argv [];
{
	progname = argv [0];
	init ();
	if (setjmp (prog_end) == 0)
	{
		(void)setjmp (prog_begin);
		yyparse ();
	}
	return 0;
}
static short yydef[] = {
	  -1,    4,   30,   17,   16,    3,   15,   14,   13,   12, 
	  11,   10,    9,    8,    7,    6,    5
};
static short yyex[] = {
	   0,    0,   -1,    1
};
static short yyact[] = {
	 -52,  -39,  -40,  -41,  -37,  -45,  -44,   -2,  -38,  -35, 
	 -34,  -36,  264,  263,  262,  260,  259,  258,  257,  256, 
	 126,   45,   40,   10,  -39,  -40,  -41,  -45,  -44,   -2, 
	 -38,  260,  259,  258,  257,  126,   45,   40,  -31,   40, 
	 -30,   61,  -46,   10,  -47,   10,  -48,   10,  -49,   10, 
	 -50,  -28,  -23,  -26,  -24,  -25,  -27,  -22,  -21,  -19, 
	 -20,  -29,  268,  266,  265,  124,   94,   47,   45,   43, 
	  42,   38,   37,   10,  -53,   10,  -29,  268,  -28,  -23, 
	 -42,  -26,  -24,  -25,  -27,  -22,  -21,  -19,  -20,  -29, 
	 268,  266,  265,  124,   94,   47,   45,   43,   42,   41, 
	  38,   37,  -28,  -23,  -43,  -26,  -24,  -25,  -27,  -22, 
	 -21,  -19,  -20,  -29,  268,  266,  265,  124,   94,   47, 
	  45,   43,   42,   41,   38,   37,  -28,  -23,  -26,  -24, 
	 -25,  -27,  -22,  -21,  -19,  -20,  -29,  268,  266,  265, 
	 124,   94,   47,   45,   43,   42,   38,   37,  -28,  -26, 
	 -27,  -29,  268,   47,   42,   37,  -28,  -26,  -24,  -25, 
	 -27,  -19,  -20,  -29,  268,  266,  265,   47,   45,   43, 
	  42,   37,  -28,  -23,  -26,  -24,  -25,  -27,  -19,  -20, 
	 -29,  268,  266,  265,   47,   45,   43,   42,   38,   37, 
	 -28,  -23,  -26,  -24,  -25,  -27,  -22,  -19,  -20,  -29, 
	 268,  266,  265,   94,   47,   45,   43,   42,   38,   37, 
	 -28,  -26,  -24,  -25,  -27,  -29,  268,   47,   45,   43, 
	  42,   37,   -1
};
static short yypact[] = {
	  12,   41,   75,   77,   77,  137,   77,   77,   77,   77, 
	 152,  152,  164,  181,  200,  216,  216,  114,   31,   31, 
	  31,   31,   31,   31,   31,   31,   31,   31,   31,   31, 
	  31,   90,   62,   49,   47,   45,   43,   39,   31,   31,   31
};
static short yygo[] = {
	 -17,  -16,  -15,  -14,  -13,  -12,  -11,  -10,   -9,   -8, 
	  -7,   -6,  -18,  -32,   -5,   -4,  -33,   40,   39,   38, 
	  30,   29,   28,   27,   26,   25,   24,   23,   22,   21, 
	  20,   19,   18,   -3,  -54,    0,   -1,   -1
};
static short yypgo[] = {
	   0,    0,    0,   34,   16,   16,   16,   16,   16,   16, 
	  16,   16,   16,   16,   16,   16,   16,   16,   16,   16, 
	  16,   16,   36,   36,   36,   36,   36,   36,   36,   36, 
	  16,    0
};
static short yyrlen[] = {
	   0,    0,    0,    3,    1,    3,    3,    3,    3,    3, 
	   3,    3,    3,    3,    3,    3,    2,    2,    3,    4, 
	   1,    1,    3,    3,    3,    3,    3,    0,    2,    3, 
	   1,    2
};
#define YYS0	50
#define YYDELTA	23
#define YYNPACT	41
#define YYNDEF	17

#define YYr29	0
#define YYr30	1
#define YYr31	2
#define YYr9	3
#define YYr12	4
#define YYr15	5
#define YYr16	6
#define YYr17	7
#define YYr18	8
#define YYr19	9
#define YYr20	10
#define YYr21	11
#define YYr22	12
#define YYr23	13
#define YYr24	14
#define YYr25	15
#define YYr27	16
#define YYr28	17
#define YYr26	18
#define YYr14	19
#define YYr11	20
#define YYr10	21
#define YYr8	22
#define YYr7	23
#define YYr6	24
#define YYr5	25
#define YYr4	26
#define YYrACCEPT	YYr29
#define YYrERROR	YYr30
#define YYrLR2	YYr31
#line 2 "yacc parser: c:/etc/yyparse.c"

/*
 * Automaton to interpret LALR(1) tables.
 *
 *	Macros:
 *		yyclearin - clear the lookahead token.
 *		yyerrok - forgive a pending error
 *		YYERROR - simulate an error
 *		YYACCEPT - halt and return 0
 *		YYABORT - halt and return 1
 *		YYRETURN(value) - halt and return value.  You should use this
 *			instead of return(value).
 *		YYREAD - ensure yychar contains a lookahead token by reading
 *			one if it does not.  See also YYSYNC.
 *
 *	Preprocessor flags:
 *		YYDEBUG - includes debug code.  The parser will print
 *			 a travelogue of the parse if this is defined
 *			 and yydebug is non-zero.
 *		YYSSIZE - size of state and value stacks (default 150).
 *		YYSTATIC - By default, the state stack is an automatic array.
 *			If this is defined, the stack will be static.
 *			In either case, the value stack is static.
 *		YYALLOC - Dynamically allocate both the state and value stacks
 *			by calling malloc() and free().
 *		YYLR2 - defined if lookahead is needed to resolve R/R or S/R conflicts
 *		YYSYNC - if defined, yacc guarantees to fetch a lookahead token
 *			before any action, even if it doesnt need it for a decision.
 *			If YYSYNC is defined, YYREAD will never be necessary unless
 *			the user explicitly sets yychar = -1
 *
 *	Copyright (c) 1983, by the University of Waterloo
 */

#ifndef YYSSIZE
# define YYSSIZE	150
#endif
#ifndef	YYDEBUG
#define	YYDEBUG	0
#endif
#define YYERROR		goto yyerrlabel
#define yyerrok		yyerrflag = 0
#define yyclearin	yychar = -1
#define YYACCEPT	YYRETURN(0)
#define YYABORT		YYRETURN(1)
#ifdef YYALLOC
# define YYRETURN(val)	{ retval = (val); goto yyReturn; }
#else
# define YYRETURN(val)	return(val)
#endif
#if YYDEBUG
/* The if..else makes this macro behave exactly like a statement */
# define YYREAD	if (yychar < 0) {					\
			if ((yychar = yylex()) < 0)			\
				yychar = 0;				\
			if (yydebug)					\
				printf("read %s (%d)\n", yyptok(yychar),\
				yychar);				\
		} else
#else
# define YYREAD	if (yychar < 0) {					\
			if ((yychar = yylex()) < 0)			\
				yychar = 0;				\
		} else
#endif
#define YYERRCODE	256		/* value of `error' */
#if __TURBOC__&&__SMALL__
#define	YYQYYP	*(int *)((int)yyq + ((int)yyq-(int)yyp))
#else
#define	YYQYYP	yyq[yyq-yyp]
#endif

YYSTYPE	yyval,				/* $$ */
	*yypvt,				/* $n */
	yylval;				/* yylex() sets this */

int	yychar,				/* current token */
	yyerrflag,			/* error flag */
	yynerrs;			/* error count */

#if YYDEBUG
int yydebug = YYDEBUG-0;		/* debug flag & tables */
extern char	*yysvar[], *yystoken[], *yyptok();
extern short	yyrmap[], yysmap[];
extern int	yynstate, yynvar, yyntoken, yynrule;
# define yyassert(condition, msg, arg) \
	if (!(condition)) { printf("\nyacc bug: "); printf(msg, arg); YYABORT; }
#else /* !YYDEBUG */
# define yyassert(condition, msg, arg)
#endif

yyparse()
{

	register short		yyi, *yyp;	/* for table lookup */
	register short		*yyps;		/* top of state stack */
	register short		yystate;	/* current state */
	register YYSTYPE	*yypv;		/* top of value stack */
	register short		*yyq;
	register int		yyj;

#ifdef YYSTATIC
	static short	yys[YYSSIZE + 1];
	static YYSTYPE	yyv[YYSSIZE + 1];
#else
#ifdef YYALLOC
	YYSTYPE *yyv;
	short	*yys;
	YYSTYPE save_yylval, save_yyval, *save_yypvt;
	int save_yychar, save_yyerrflag, save_yynerrs;
	int retval;
#if 0	/* defined in <stdlib.h>*/
	extern char	*malloc();
#endif 0
#else
	short		yys[YYSSIZE + 1];
	static YYSTYPE	yyv[YYSSIZE + 1];	/* historically static */
#endif
#endif

#ifdef YYALLOC
	yys = (short *) malloc((YYSSIZE + 1) * sizeof(short));
	yyv = (YYSTYPE *) malloc((YYSSIZE + 1) * sizeof(YYSTYPE));
	if (yys == (short *)0 || yyv == (YYSTYPE *)0) {
		yyerror("Not enough space for parser stacks");
		return 1;
	}
	save_yylval = yylval;
	save_yyval = yyval;
	save_yypvt = yypvt;
	save_yychar = yychar;
	save_yyerrflag = yyerrflag;
	save_yynerrs = yynerrs;
#endif

	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;
	yyps = yys;
	yypv = yyv;
	yystate = YYS0;		/* start state */

yyStack:
	yyassert((unsigned)yystate < yynstate, "state %d\n", yystate);
	if (++yyps > &yys[YYSSIZE]) {
		yyerror("Parser stack overflow");
		YYABORT;
	}
	*yyps = yystate;	/* stack current state */
	*++yypv = yyval;	/* ... and value */

#if YYDEBUG
	if (yydebug)
		printf("state %d (%d), char %s (%d)\n", yysmap[yystate],
			yystate, yyptok(yychar), yychar);
#endif

	/*
	 *	Look up next action in action table.
	 */
yyEncore:
#ifdef YYSYNC
	YYREAD;
#endif
	if (yystate >= sizeof yypact/sizeof yypact[0]) 	/* simple state */
		yyi = yystate - YYDELTA;	/* reduce in any case */
	else {
		if(*(yyp = &yyact[yypact[yystate]]) >= 0) {
			/* Look for a shift on yychar */
#ifndef YYSYNC
			YYREAD;
#endif
			yyq = yyp;
			yyi = yychar;
#if __TURBOC__&&__SMALL__
			/* yyi is in di, yyp is in si */
		L01:
			asm lodsw	/* ax = *yyp++; */
			asm cmp yyi, ax
			asm jl L01
#else
			while (yyi < *yyp++)
				;
#endif
			if (yyi == yyp[-1]) {
				yystate = ~YYQYYP;
#if YYDEBUG
				if (yydebug)
					printf("shift %d (%d)\n", yysmap[yystate], yystate);
#endif
				yyval = yylval;		/* stack what yylex() set */
				yychar = -1;		/* clear token */
				if (yyerrflag)
					yyerrflag--;	/* successful shift */
				goto yyStack;
			}
		}

		/*
	 	 *	Fell through - take default action
	 	 */

		if (yystate >= sizeof yydef /sizeof yydef[0])
			goto yyError;
		if ((yyi = yydef[yystate]) < 0)	 { /* default == reduce? */
											/* Search exception table */
			yyassert((unsigned)~yyi < sizeof yyex/sizeof yyex[0],
				"exception %d\n", yystate);
			yyp = &yyex[~yyi];
#ifndef YYSYNC
			YYREAD;
#endif
			while((yyi = *yyp) >= 0 && yyi != yychar)
				yyp += 2;
			yyi = yyp[1];
			yyassert(yyi >= 0,"Ex table not reduce %d\n", yyi);
		}
	}

#ifdef YYLR2
yyReduce:	/* reduce yyi */
#endif
	yyassert((unsigned)yyi < yynrule, "reduce %d\n", yyi);
	yyj = yyrlen[yyi];
#if YYDEBUG
	if (yydebug) printf("reduce %d (%d), pops %d (%d)\n", yyrmap[yyi],
		yyi, yysmap[yyps[-yyj]], yyps[-yyj]);
#endif
	yyps -= yyj;		/* pop stacks */
	yypvt = yypv;		/* save top */
	yypv -= yyj;
	yyval = yypv[1];	/* default action $$ = $1 */
	switch (yyi) {		/* perform semantic action */
		
case YYr4: {	/* list :  list expr '\n' */
#line 28
 
					  if (radix == 16)
						printf ("\t%lx\n", yypvt[-1].val);
					  else if (radix == 10)
						printf ("\t%lu\n", yypvt[-1].val);
					  else
						printf ("\t%lo\n", yypvt[-1].val);
					
} break;

case YYr5: {	/* list :  list HELP '\n' */
#line 36
 puthelp(); 
} break;

case YYr6: {	/* list :  list QUIT '\n' */
#line 37
 longjmp (prog_end, 1); 
} break;

case YYr7: {	/* list :  list CHRADIX '\n' */
#line 38

					  if (*(yypvt[-1].sym->name) == 'h')
						radix = 16; 
					  else if (*(yypvt[-1].sym->name) == 'd')
						radix = 10; 
					  else
						radix = 8; 
					
} break;

case YYr8: {	/* list :  list error '\n' */
#line 46
 yyerrok; 
} break;

case YYr9: {	/* asgn :  VAR '=' expr */
#line 48
 yyval.val = yypvt[-2].sym->u.val = yypvt[0].val; yypvt[-2].sym->type = VAR; 
} break;

case YYr10: {	/* expr :  NUMBER */
#line 50
 yyval.val = yypvt[0].val; 
} break;

case YYr11: {	/* expr :  CONST */
#line 51
 yyval.val = yypvt[0].sym->u.val; 
} break;

case YYr12: {	/* expr :  VAR */
#line 52
 
			if (yypvt[0].sym->type == UNDEF)
				execerror ("undefined variable", yypvt[0].sym->name);
			yyval.val = yypvt[0].sym->u.val; 
} break;

case YYr14: {	/* expr :  BLTIN '(' expr ')' */
#line 57
 yyval.val = (*(yypvt[-3].sym->u.ptr))(yypvt[-1].val); 
} break;

case YYr15: {	/* expr :  expr LSH expr */
#line 58
 yyval.val = yypvt[-2].val << yypvt[0].val; 
} break;

case YYr16: {	/* expr :  expr RSH expr */
#line 59
 yyval.val = yypvt[-2].val >> yypvt[0].val; 
} break;

case YYr17: {	/* expr :  expr '|' expr */
#line 60
 yyval.val = yypvt[-2].val | yypvt[0].val; 
} break;

case YYr18: {	/* expr :  expr '^' expr */
#line 61
 yyval.val = yypvt[-2].val ^ yypvt[0].val; 
} break;

case YYr19: {	/* expr :  expr '&' expr */
#line 62
 yyval.val = yypvt[-2].val & yypvt[0].val; 
} break;

case YYr20: {	/* expr :  expr '+' expr */
#line 63
 yyval.val = yypvt[-2].val + yypvt[0].val; 
} break;

case YYr21: {	/* expr :  expr '-' expr */
#line 64
 yyval.val = yypvt[-2].val - yypvt[0].val; 
} break;

case YYr22: {	/* expr :  expr '*' expr */
#line 65
 yyval.val = yypvt[-2].val * yypvt[0].val; 
} break;

case YYr23: {	/* expr :  expr '/' expr */
#line 66
	
			if (yypvt[0].val == 0)
				execerror ("division by zero", (char *)0);
			yyval.val = yypvt[-2].val / yypvt[0].val; 
} break;

case YYr24: {	/* expr :  expr '%' expr */
#line 70
	
			if (yypvt[0].val == 0)
				execerror ("modulo zero", (char *)0);
			yyval.val = yypvt[-2].val % yypvt[0].val; 
} break;

case YYr25: {	/* expr :  expr POW expr */
#line 74
 yyval.val = ulpow (yypvt[-2].val, yypvt[0].val); 
} break;

case YYr26: {	/* expr :  '(' expr ')' */
#line 75
 yyval.val = yypvt[-1].val; 
} break;

case YYr27: {	/* expr :  '-' expr */
#line 76
 yyval.val = -yypvt[0].val; 
} break;

case YYr28: {	/* expr :  '~' expr */
#line 77
 yyval.val = ~ yypvt[0].val; 
} break;
#line 237 "yacc parser: c:/etc/yyparse.c"
	case YYrACCEPT:
		YYACCEPT;
	case YYrERROR:
		goto yyError;
#ifdef YYLR2
	case YYrLR2:
#ifndef YYSYNC
		YYREAD;
#endif
		yyj = 0;
		while(yylr2[yyj] >= 0) {
			if(yylr2[yyj] == yystate && yylr2[yyj+1] == yychar
			&& yylook(yys+1,yyps,yystate,yychar,yy2lex(),yylr2[yyj+2]))
					break;
			yyj += 3;
		}
		if(yylr2[yyj] < 0)
			goto yyError;
		if(yylr2[yyj+2] < 0) {
			yystate = ~ yylr2[yyj+2];
			goto yyStack;
		}
		yyi = yylr2[yyj+2];
		goto yyReduce;
#endif
	}

	/*
	 *	Look up next state in goto table.
	 */

	yyp = &yygo[yypgo[yyi]];
	yyq = yyp++;
	yyi = *yyps;
#if	__TURBOC__ && __SMALL__
	/* yyi is in di, yyp is in si */
L02:
	asm lodsw		/* ax = *yyp++; */
	asm cmp yyi, ax
	asm jl L02
#else
	while (yyi < *yyp++)
		;
#endif
	yystate = ~(yyi == *--yyp? YYQYYP: *yyq);
	goto yyStack;

yyerrlabel:	;		/* come here from YYERROR	*/
/*
#pragma used yyerrlabel
 */
	yyerrflag = 1;
	yyps--, yypv--;
	
yyError:
	switch (yyerrflag) {

	case 0:		/* new error */
		yynerrs++;
		yyi = yychar;
		yyerror("Syntax error");
		if (yyi != yychar) {
			/* user has changed the current token */
			/* try again */
			yyerrflag++;	/* avoid loops */
			goto yyEncore;
		}

	case 1:		/* partially recovered */
	case 2:
		yyerrflag = 3;	/* need 3 valid shifts to recover */
			
		/*
		 *	Pop states, looking for a
		 *	shift on `error'.
		 */

		for ( ; yyps > yys; yyps--, yypv--) {
			if (*yyps >= sizeof yypact/sizeof yypact[0])
				continue;
			yyp = &yyact[yypact[*yyps]];
			yyq = yyp;
			do
				;
			while (YYERRCODE < *yyp++);
			if (YYERRCODE == yyp[-1]) {
				yystate = ~YYQYYP;
				goto yyStack;
			}
				
			/* no shift in this state */
#if YYDEBUG
			if (yydebug && yyps > yys+1)
				printf("Error recovery pops state %d (%d), uncovers %d (%d)\n",
					yysmap[yyps[0]], yyps[0],
					yysmap[yyps[-1]], yyps[-1]);
#endif
			/* pop stacks; try again */
		}
		/* no shift on error - abort */
		break;

	case 3:
		/*
		 *	Erroneous token after
		 *	an error - discard it.
		 */

		if (yychar == 0)  /* but not EOF */
			break;
#if YYDEBUG
		if (yydebug)
			printf("Error recovery discards %s (%d), ",
				yyptok(yychar), yychar);
#endif
		yyclearin;
		goto yyEncore;	/* try again in same state */
	}
	YYABORT;

#ifdef YYALLOC
yyReturn:
	yylval = save_yylval;
	yyval = save_yyval;
	yypvt = save_yypvt;
	yychar = save_yychar;
	yyerrflag = save_yyerrflag;
	yynerrs = save_yynerrs;
	free((char *)yys);
	free((char *)yyv);
	return(retval);
#endif
}

#ifdef YYLR2
yylook(s,rsp,state,c1,c2,i)
short *s;		/* stack		*/
short *rsp;		/* real top of stack	*/
int state;		/* current state	*/
int c1;			/* current char		*/
int c2;			/* next char		*/
int i;			/* action S < 0, R >= 0	*/
{
	int j;
	short *p,*q;
	short *sb,*st;
#if YYDEBUG
	if(yydebug) {
		printf("LR2 state %d (%d) char %s (%d) lookahead %s (%d)",
			yysmap[state],state,yyptok(c1),c1,yyptok(c2),c2);
		if(i > 0)
			printf("reduce %d (%d)\n", yyrmap[i], i);
		else
			printf("shift %d (%d)\n", yysmap[i], i);
	}
#endif
	st = sb = rsp+1;
	if(i >= 0)
		goto reduce;
  shift:
	state = ~i;
	c1 = c2;
	if(c1 < 0)
		return 1;
	c2 = -1;

  stack:
  	if(++st >= &s[YYSSIZE]) {
		yyerror("Parser Stack Overflow");
		return 0;
	}
	*st = state;
	if(state >= sizeof yypact/sizeof yypact[0])
		i = state- YYDELTA;
	else {
		p = &yyact[yypact[state]];
		q = p;
		i = c1;
		while(i < *p++)
			;
		if(i == p[-1]) {
			state = ~q[q-p];
			c1 = c2;
			if(c1 < 0)
				return 1;
			c2 = -1;
			goto stack;
		}
		if(state >= sizeof yydef/sizeof yydef[0])
			return 0
		if((i = yydef[state]) < 0) {
			p = &yyex[~i];
			while((i = *p) >= 0 && i != c1)
				p += 2;
			i = p[1];
		}
	}
  reduce:
  	j = yyrlen[i];
	if(st-sb >= j)
		st -= j;
	else {
		rsp -= j+st-sb;
		st = sb;
	}
	switch(i) {
	case YYrERROR:
		return 0;
	case YYrACCEPT:
		return 1;
	case YYrLR2:
		j = 0;
		while(yylr2[j] >= 0) {
			if(yylr2[j] == state && yylr2[j+1] == c1)
				if((i = yylr2[j+2]) < 0)
					goto shift;
				else
					goto reduce;
		}
		return 0;
	}
	p = &yygo[yypgo[i]];
	q = p++;
	i = st==sb ? *rsp : *st;
	while(i < *p++);
	state = ~(i == *--p? q[q-p]: *q);
	goto stack;
}
#endif
		
#if YYDEBUG
	
/*
 *	Print a token legibly.
 *	This won't work if you roll your own token numbers,
 *	but I've found it useful.
 */
char *
yyptok(i)
{
	static char	buf[10];

	if (i >= YYERRCODE)
		return yystoken[i-YYERRCODE];
	if (i < 0)
		return "";
	if (i == 0)
		return "$end";
	if (i < ' ')
		sprintf(buf, "'^%c'", i+'@');
	else
		sprintf(buf, "'%c'", i);
	return buf;
}
#endif
#ifdef YYDEBUG
char * yystoken[] = {
	"error",
	"NUMBER",
	"CONST",
	"VAR",
	"BLTIN",
	"UNDEF",
	"QUIT",
	"HELP",
	"CHRADIX",
	"LSH",
	"RSH",
	"UNARYMINUS",
	"POW",
	0
};
char * yysvar[] = {
	"$accept",
	"expr",
	"asgn",
	"list",
	0
};
short yyrmap[] = {
	  29,   30,   31,    9,   12,   15,   16,   17,   18,   19, 
	  20,   21,   22,   23,   24,   25,   27,   28,   26,   14, 
	  11,   10,    8,    7,    6,    5,    4,    1,    2,    3, 
	  13,    0
};
short yysmap[] = {
	   1,    8,   14,   16,   18,   41,   42,   43,   44,   45, 
	  46,   47,   48,   49,   50,   51,   52,   40,   36,   35, 
	  34,   33,   32,   31,   30,   29,   28,   27,   26,   21, 
	  20,   19,   13,   12,   11,   10,    9,    5,    4,    3, 
	   2,   39,   53,    6,    7,   22,   23,   24,   25,   37, 
	   0,   15,   38,   17
};
int yyntoken = 27, yynvar = 4, yynstate = 54, yynrule = 32;
#endif
