
/*	symbol.c	hexcalc symbol table management routines
 */

#include <string.h>
#include "hexcalc.h"

/* head ptr for the symbol table linked list */
STATIC Symbol *symlist = (Symbol *)0;

/******************************************************************************/

Symbol *lookup (s)
char *s;
{
	Symbol *sp;

	for (sp = symlist; sp != (Symbol *)0; sp = sp->next)
	{
		if (strcmp (sp->name, s) == 0) return sp;
	}
	return (Symbol *)0;
}

/******************************************************************************/

char *emalloc (n)
unsigned n;
{
	void *p, *malloc();

	if ((p = malloc (n)) == (void *)0)
	{
		execerror ("out of memory", (char *)0);
	}
	return (char *)p;
}

/******************************************************************************/

Symbol *install (s, t, l)	/* install s in symbol table */
char *s;
int t;
BASE_TYPE l;
{
	Symbol *sp = (Symbol *)emalloc (sizeof(Symbol));

	sp->name = (char *)emalloc (strlen (s) + 1);	/* + 1 for '\0' */
	strcpy (sp->name, s);
	sp->type = t;
	sp->u.val = l;
	sp->next = symlist;
	symlist = sp;
	return sp;
}
