
/*	init.c		hexcalc initilization code
 */

#include "hexcalc.h"
#ifdef __TURBOC__
#include "ytab.h"
#else
#include "y.tab.h"
#endif

STATIC struct		/* constants */
{
	char *name;
	BASE_TYPE cval;
} consts[] = 
	{
		(char *)0,		(BASE_TYPE)0
	};

STATIC struct		/* built-ins */
{
	char *name;
	BASE_TYPE (*func)();
} builtins[] = 
	{
		"DEC",		dec,
		"OCT",		oct,
		"HEX",		hex,
		(char *)0,	(BASE_TYPE(*)())0
	};

STATIC struct 		/* keywords */
{
	char *name;
	short token;
} keywords[] =
	{
		"oct",		CHRADIX,
		"HELP",		HELP,
		"exit",         QUIT,
		"help",		HELP,
		"quit",         QUIT,
		"dec",		CHRADIX,
		"hex",		CHRADIX,
		(char *)0,	0
	};

/******************************************************************************/

init()		/* install keywords, constants, and built-ins in table */
{
	int i;
	Symbol *s;

	for (i=0; keywords [i].name != (char *)0; ++i)
	{
		install (keywords [i].name, keywords [i].token, (BASE_TYPE)0);
	}
	for (i=0; consts [i].name != (char *)0; ++i)
	{
		install (consts [i].name, CONST, consts [i].cval);
	}
	for (i=0; builtins [i].name != (char *)0; ++i)
	{
		s = install (builtins [i].name, BLTIN, (BASE_TYPE)0);
		s->u.ptr = builtins [i].func;
	}
}
