#include <stdio.h>
#include <math.h>
#include "complex.h"

#define ndim 3
#define ndat 512

main()
{
	int i, j, k, l, ll, isign = 1;
	int nn[ndim];

#ifdef SPEED
	struct fcomplex data[ndat];
#else
	struct complex data[ndat];
#endif

	for (i = 0; i < ndim; ++i)
	nn[i] = 4 << i;

	for (i = 0; i < nn[0]; ++i)
		for (j = 0; j < nn[1]; ++j)
			for (k = 0; k < nn[2]; ++k) {
				l = (i * nn[1] + j) * nn[2] + k;
				ll = (l << 1) + 1;
				data[l].x = ll;
				data[l].y = ll + 1;
			}
	fftn(data, nn, ndim, isign);
	isign = -1;

	printf("\nDouble 3-dimensional Transform");
	printf("\nDouble Transf.  Original Data  Ratio");
	printf("\nReal   Imag.	Real   Imag.   Real   Imag.");
 
	fftn(data, nn, ndim, isign);

	for (i = 0; i < 4; ++i) {
		j = i << 1;
		k = j << 1;
		l = (i * nn[1] + j) * nn[2] + k;
		ll = (l << 1) + 1;
		printf("\n%.2lf %.2lf %d %d %.2lf %.2lf", data[l].x, data[l].y, ll, ll+1, data[l].x / ll, data[l].y / (ll+1));
	}

	printf("\nThe product of transform lengths is: %d\n", nn[0] * nn[1] * nn[2]);
}
