/*--------------------------------------------------------------------------
 Generate bit-reversing code for a N-point radix-2 FFT.
 Reads two lines from stdin giving the format of the macro
 that swaps two complex numbers, for instance
    SWAP_COMPLEX FFT_BUF+%d FFT_BUF+%d
    *SWAP_COMPLEX FFT_BUF+%d FFT_BUF+%d

 The first %d is expanded to the bit-reversed number; the second %d is
 expanded to the non-bit-reversed number.
 If desired, the second %d may be omitted.
 The second line is used when the two arguments would be identical.

 Dan Kegel, rochester!srs!dan, S.R. Systems, Oct '88
 This code is hereby placed in the public domain without any promise
 that it functions as intended, or at all.
--------------------------------------------------------------------------*/
#include <stdio.h>

/*--------------------------------------------------------------------------
 Stupid bitreversal routine.  Works for n <= 8192.
--------------------------------------------------------------------------*/
int
bitrev(i, n)
    register int i;
    register int n;
{
    n >>= 1;
    return
	((i & 1<<0) ? (n>>0) : 0) +
	((i & 1<<1) ? (n>>1) : 0) +
	((i & 1<<2) ? (n>>2) : 0) +
	((i & 1<<3) ? (n>>3) : 0) +
	((i & 1<<4) ? (n>>4) : 0) +
	((i & 1<<5) ? (n>>5) : 0) +
	((i & 1<<6) ? (n>>6) : 0) +
	((i & 1<<7) ? (n>>7) : 0) +
	((i & 1<<8) ? (n>>8) : 0) +
	((i & 1<<9) ? (n>>9) : 0) +
	((i & 1<<10) ? (n>>10) : 0) +
	((i & 1<<11) ? (n>>11) : 0) +
	((i & 1<<12) ? (n>>12) : 0) +
	((i & 1<<13) ? (n>>13) : 0);
}

main(argc, argv)
    int argc;
    char **argv;
{
    int log_n;
    int n;
    int i;
    char format[2][256];	/* [0] is normal swap, [1] is no-op swap */

    if (argc < 2) {
	(void) fprintf(stderr, "usage: %s log_fft_size < instruction_format\n\
Outputs inline code to implement bit reversal for 2^log_fft_size-point fft.\n\
Input is two swap instruction templates, for example:\n\
    SWAP	X%%03d,X%%03d\n\
    * (swap %%d and %%d, so do nothing)\n\
Second line used when operands are identical.\n\
", argv[0]);
	exit(1);
    }

    /* Get arguments */
    log_n = atoi(argv[1]);
    if (log_n < 2 || log_n > 13) {
	(void) fprintf(stderr, "log_fft_size %s out of range 2..13\n", 
	    argv[1]);
	exit(1);
    }
    n = 1 << log_n;

    /* Get formats for normal and no-op swaps. */
    for (i=0; i<2; i++)
	(void) gets(format[i]);

    /* Output bitreversal code. */
    for (i=0; i<n; i++) {
	int b = bitrev(i,n);
	if (b > i) {
	    (void) printf(format[0], b, i);
	    (void) putchar('\n');
	} else if (b == i) {
	    (void) printf(format[1], b, i);
	    (void) putchar('\n');
	}
    }

    exit(0);
}
