
/*  @(#)xview.c 1.6 90/06/26
 *
 *  XView dependent graphics routines used by faces,
 *  the visual mail and print job monitor.
 * 
 *  Copyright (c) Rich Burridge - Sun Microsystems Australia.
 *                                All rights reserved.
 *
 *  Permission is given to distribute these sources, as long as the
 *  copyright messages are not removed, and no monies are exchanged. 
 * 
 *  No responsibility is taken for any errors or inaccuracies inherent
 *  either to the comments or the code of this program, but if reported
 *  to me, then an attempt will be made to fix them.
 */

#include <stdio.h>
#include "faces.h"
#include "extern.h"
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/icon.h>
#include <X11/Xlib.h>

#define  DEF_FONT  "fixed"
#define  F_ICON    0                  /* Icon index to frame array. */
#define  F_WINDOW  1                  /* Window index to frame array. */
#define  FONT      "times-roman-10"

#define  NOTIFY_INTERPOSE_EVENT_FUNC  (void) notify_interpose_event_func
#define  NOTIFY_SET_ITIMER_FUNC       (void) notify_set_itimer_func
#define  XV_DESTROY                   (void) xv_destroy
#define  XV_SET                       (void) xv_set

#define  ITIMER_NULL             ((struct itimerval *) 0)

int repaint_proc() ;

Canvas canvas ;
Canvas_paint_window pw ;
Frame frame ;
Icon faces_icon ;

Display *dpy ;
Drawable xid[2] ;               /* Xlib pointers to the screen and the icon. */
Pixmap pr[3] = { NULL, NULL, NULL } ;     /* Current memory pixmaps. */
Pixmap old_pr[2] = { NULL, NULL } ;       /* Previous memory pixmaps. */

/* Array of the different icon images. */
Pixmap images[MAXICONS] = {
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL
} ;

GC gc ;                       /* Main drawing graphics context. */
GC tilegc ;                   /* Graphics context for tiling background. */
Window root ;
XFontStruct *sfont ;
XGCValues gc_val ;            /* Used to setup graphics context values. */
int screen ;                  /* Default graphics display screen. */
int toclear ;                 /* Set if faces icon needs clearing. */
unsigned int depth ;
unsigned long backgnd ;       /* Default background color. */
unsigned long foregnd ;       /* Default foreground color. */
unsigned long gc_mask ;       /* Mask for setting graphic context values. */


adjust_image(dtype, itype, row, column)  /* Put new face in memory pixrect. */
enum disp_type dtype ;
enum icon_type itype ;
int row, column ;
{
  if (mtype == MONNEW)
    XCopyArea(dpy, pr[(int) dtype], pr[(int) dtype], gc, 0, 0,
              (maxcols-1)*imagewidth, imageheight, imagewidth, 0) ;

  XCopyArea(dpy, images[(int) itype], pr[(int) dtype], gc, 0, 0,
            imagewidth, imageheight, column*imagewidth, row*imageheight) ;
}


/*ARGSUSED*/
beep_flash(beeps, flashes)    /* Perform visual feedback. */
int beeps, flashes ;
{
  int i ;

  for (i = 0; i < beeps; i++) window_bell(frame) ;
}


/*ARGSUSED*/
void
canvas_proc(canvas, event, arg)
Canvas canvas ;
Event *event ;
caddr_t arg ;
{
  int nextc ;

  nextc = event_id(event) ;
  if (event_is_down(event) && nextc == MS_LEFT)
    {
      wdtype = (wdtype == DISP_NAME) ? DISP_OTHER : DISP_NAME ;
      XCopyArea(dpy, pr[(int) wdtype], xid[F_WINDOW], gc, 0, 0,
                width, height, 0, 0) ;
    }
  else if (mtype == MONNEW && event_is_ascii(event) && nextc == DEL)
    {
      repl_image(DISP_NAME,  CUROFF, width, height) ;
      repl_image(DISP_OTHER, CUROFF, width, height) ;
      toclear = 1 ;
      do_check() ;
    }
}


Notify_value
check_mail()
{
  do_check() ;
}


create_pixrects(width, height)   /* Create pixrects for the face images. */
int width, height ;
{
  old_pr[(int) DISP_NAME]  = pr[(int) DISP_NAME] ;
  old_pr[(int) DISP_OTHER] = pr[(int) DISP_OTHER] ;

  make_area(DISP_NAME, width, height) ;
  repl_image(DISP_NAME, CUROFF, width, height) ;

  if (toclear && mtype == MONNEW)
    {
      repl_image(DISP_OTHER, OLDOFF, width, height) ;
      toclear = 0 ;
    }

  make_area(DISP_OTHER, width, height) ;
  repl_image(DISP_OTHER, CUROFF, width, height) ;

  if (mtype == MONNEW && old_pr[(int) DISP_NAME] != NULL)
    XCopyArea(dpy, old_pr[(int) DISP_NAME], pr[(int) DISP_NAME], gc, 0, 0,
              (unsigned int) width, (unsigned int) height, 0, 0) ;
  if (mtype == MONNEW && old_pr[(int) DISP_OTHER] != NULL)
    XCopyArea(dpy, old_pr[(int) DISP_OTHER], pr[(int) DISP_OTHER], gc, 0, 0,
              (unsigned int) width, (unsigned int) height, 0, 0) ;
}


destroy_image(itype)
enum icon_type itype ;
{
  if (images[(int) itype] != NULL)
    {
      XFreePixmap(dpy, images[(int) itype]) ;
      images[(int) itype] = NULL ;
    }
}


static Notify_value
frame_interpose(frame, event, arg, type)
Frame frame ;
Event *event ;
Notify_arg arg ;
Notify_event_type type ;
{
  Notify_value rc ;

  rc = notify_next_event_func(frame, event, arg, type) ;
  if (event_action(event) == ACTION_CLOSE)
    {
      XCopyArea(dpy, pr[(int) DISP_ICON], xid[F_ICON], gc, 0, 0, 
                imagewidth, imageheight, 0, 0) ; 
    }
  return(rc) ;
}


init_font()
{
  if (!(sfont = XLoadQueryFont(dpy, FONT)))
    if (!(sfont = XLoadQueryFont(dpy, DEF_FONT)))
      {
        perror("couldn't get the default font.") ;
        exit(1) ;
      }
}


init_ws_type(argc, argv)
int argc ;
char *argv[] ;
{
  int i, j ;
  unsigned short buf[256] ;

  xv_init(XV_INIT_ARGS, argc, argv, 0) ;
  frame = xv_create(XV_NULL, FRAME, 0) ;   /* Needed to get Xlib handles now.*/

  faces_icon = xv_create(XV_NULL,   ICON,
                         XV_WIDTH,  imagewidth,
                         XV_HEIGHT, imageheight,
                         0) ;
  xid[F_ICON] = (Drawable) xv_get(faces_icon, XV_XID) ;

  dpy  = (Display *) xv_get(frame, XV_DISPLAY) ;
  screen  = DefaultScreen(dpy) ;
  root = RootWindow(dpy, screen) ;
  foregnd = BlackPixel(dpy, screen) ;
  backgnd = WhitePixel(dpy, screen) ;
  depth = DefaultDepth(dpy, screen) ;

  init_font() ;

  gc_mask = GCFont | GCForeground | GCBackground | GCGraphicsExposures ;
  gc_val.font = sfont->fid ;
  gc_val.foreground = foregnd ;
  gc_val.background = backgnd ;
  gc_val.graphics_exposures = False ;
  gc = XCreateGC(dpy, root, gc_mask, &gc_val) ;

  tilegc = XCreateGC(dpy, root, gc_mask, &gc_val) ;
  if (depth == 1) XSetFillStyle(dpy, tilegc, FillOpaqueStippled) ;
  else            XSetFillStyle(dpy, tilegc, FillTiled) ;

  for (i = 0; i < 16; i++)    /* Load default gray background. */
    {
      for (j = 0; j < 4; j++) buf[i * 16      + j] = 0x7777 ;
      for (j = 0; j < 4; j++) buf[i * 16 +  4 + j] = 0xDDDD ;
      for (j = 0; j < 4; j++) buf[i * 16 +  8 + j] = 0xBBBB ;
      for (j = 0; j < 4; j++) buf[i * 16 + 12 + j] = 0xEEEE ;
    }

  if (strlen(bgicon)) GET_SUN_ICON(bgicon, buf) ;
  load_icon(BACKGROUND, buf) ;

  STRCPY(fname[0], "sun.icon") ;
  STRCPY(fname[1], "48x48x1") ;
  STRCPY(fname[2], "face.xbm") ;
  maxtypes = 3 ;
  gtype = XVIEW ;
  pr[(int) DISP_NAME] = pr[(int) DISP_OTHER] = NULL ;
  old_pr[(int) DISP_NAME] = old_pr[(int) DISP_OTHER] = NULL ;
  toclear = 0 ;
  return 0 ;
}


/* Create a server image from given image data. */

/*ARGSUSED*/
load_icon(itype, sbuf, not_flipped)
enum icon_type itype ;
unsigned short sbuf[256] ;
int not_flipped ;
{
  char cbuf[512] ;
  int i ;

  for (i = 0; i < 256; i++)
    {
      cbuf[i*2+0] = revtable[(sbuf[i] >> 8) & 0xFF] ;
      cbuf[i*2+1] = revtable[sbuf[i] & 0xFF] ;
    }
  images[(int) itype] = XCreatePixmapFromBitmapData(dpy, root,
                                           cbuf, iconwidth, iconheight,
                                           foregnd, backgnd, depth) ;
}


make_area(dtype, width, height)
enum disp_type dtype ;
int width, height ;
{
  pr[(int) dtype] = XCreatePixmap(dpy, root, (unsigned int) width,
                                  (unsigned int) height, depth) ;
  XSetFunction(dpy, gc, GXandInverted) ;
  XFillRectangle(dpy, pr[(int) dtype], gc, 0, 0, width, height) ;
  XSetFunction(dpy, gc, GXcopy) ;
}


/*ARGSUSED*/
make_frame(argc, argv)
int argc ;
char *argv[] ;
{
  XV_SET(frame,
         FRAME_ICON,                  faces_icon,
         FRAME_LABEL,                 "faces",
         FRAME_NO_CONFIRM,            TRUE,
         FRAME_SHOW_FOOTER,           FALSE,
         XV_WIDTH,                    maxcols * imagewidth,
         XV_HEIGHT,                   imageheight * 10,
         0) ;
  NOTIFY_INTERPOSE_EVENT_FUNC(frame, frame_interpose, 0) ;

  canvas = xv_create(frame,               CANVAS,
                     CANVAS_REPAINT_PROC, repaint_proc,
                     CANVAS_RETAINED,     FALSE,
                     CANVAS_PAINTWINDOW_ATTRS,
                     WIN_CONSUME_EVENTS,
                       MS_LEFT, WIN_ASCII_EVENTS,
                       WIN_LEFT_KEYS, WIN_TOP_KEYS, WIN_RIGHT_KEYS,
                       0,
                     WIN_IGNORE_EVENTS,
                       LOC_MOVE, LOC_DRAG,
                       0,
                     WIN_EVENT_PROC, canvas_proc,
                       0,
                     0) ;

  pw = canvas_paint_window(canvas) ;
  xid[F_WINDOW] = (Drawable) xv_get(pw, XV_XID) ;

  width = maxcols * imagewidth ;
  height = imageheight ;
}


make_icon()
{
  if (mtype == MONPRINTER) adjust_image(DISP_ICON, NOPRINT, 0, 0) ;
  else                     adjust_image(DISP_ICON, NOMAIL,  0, 0) ;
}


/*ARGSUSED*/
repaint_proc(canvas, window, repaint_area)
Canvas canvas ;
Xv_Window window ;
Rectlist *repaint_area ;
{
  XCopyArea(dpy, pr[(int) wdtype], xid[F_WINDOW], gc, 0, 0,
            (unsigned int) width, (unsigned int) height, 0, 0) ;
}


repl_image(dtype, dest, width, height)
enum disp_type dtype ;
enum image_type dest ;
int width, height ;
{
  Pixmap dpm ;

  if (dest == CUROFF) dpm = pr[(int) dtype] ;
  else dpm = old_pr[(int) dtype] ;
  if (depth == 1) XSetStipple(dpy, tilegc, images[(int) BACKGROUND]) ;
  else XSetTile(dpy, tilegc, images[(int) BACKGROUND]) ;
  XFillRectangle(dpy, dpm, tilegc, 0, 0, width, height) ;
}


show_display()    /* Show the latest set of mail icon faces. */
{
  Rect *temprect ;

  if (invert)     /* Invert the memory pixrects before displaying. */
    {
      XSetFunction(dpy, gc, GXcopyInverted) ;
      XCopyArea(dpy, pr[(int) DISP_NAME], pr[(int) DISP_NAME], gc, 0, 0,
                (unsigned int) width, (unsigned int) height, 0, 0) ;
      XCopyArea(dpy, pr[(int) DISP_OTHER], pr[(int) DISP_OTHER], gc, 0, 0,
                (unsigned int)  width, (unsigned int) height, 0, 0) ;
    }

  XCopyArea(dpy, pr[(int) DISP_ICON], xid[F_ICON], gc, 0, 0,
            (unsigned int) width, (unsigned int) height, 0, 0) ;
 
  temprect = (Rect *) xv_get(frame, FRAME_OPEN_RECT) ;
  temprect->r_height = height ;
  temprect->r_width = width ;
  XV_SET(frame, FRAME_OPEN_RECT, temprect, 0) ;

  XCopyArea(dpy, pr[(int) wdtype], xid[F_WINDOW], gc, 0, 0,
            (unsigned int) width, (unsigned int) height, 0, 0) ;

  if (newmail) beep_flash(beeps, flashes) ;
  if (old_pr[(int) DISP_NAME])  XFreePixmap(dpy, old_pr[(int) DISP_NAME]) ;
  if (old_pr[(int) DISP_OTHER]) XFreePixmap(dpy, old_pr[(int) DISP_OTHER]) ;
  old_pr[(int) DISP_NAME] = NULL ;
  old_pr[(int) DISP_OTHER] = NULL ;
  XSync(dpy, 0) ;
}


start_tool()
{
  struct itimerval tval ;

  tval.it_interval.tv_usec = 0 ;
  tval.it_interval.tv_sec = period ;
  tval.it_value.tv_usec = 0 ;
  tval.it_value.tv_sec = period ;
  NOTIFY_SET_ITIMER_FUNC(frame, check_mail,
                         ITIMER_REAL, &tval, ITIMER_NULL) ;
  xv_main_loop(frame) ;
}


text(dtype, jtype, str)
enum disp_type dtype ;
enum just_type jtype ;
char *str ;
{
  int len ;
  int c, r ;         /* Column and row position for this face. */
  int x, y ;         /* Position of start of this text string. */

  c = column ;
  r = row ;
  switch (dtype)
    {
      case DISP_ALL    : text(DISP_ICON,  jtype, str) ;
      case DISP_BOTH   : text(DISP_NAME,  jtype, str) ;
                         text(DISP_OTHER, jtype, str) ;
                         return ;
      case DISP_ICON   : c = r = 0 ;
    }

  if ((len = strlen(str)) > 10)      /* Character length of text. */
    {
      len = 10 ;
      str[10] = '\0' ;               /* Maximum of 10 characters. */
    }
  switch (jtype)
    {
      case LEFT  : x =  c      * imagewidth + 2 ;
                   y = (r + 1) * imageheight - 5 ;
                   break ;
      case RIGHT : x = (c + 1) * imagewidth - (len * 6) - 2 ;
                   y = (r + 1) * imageheight - 5 ;
    }
  XSetFunction(dpy, gc, GXandInverted) ;
  XFillRectangle(dpy, pr[(int) dtype], gc, x, y-9, (unsigned int) len*6+2, 13) ;
  XSetFunction(dpy, gc, GXxor) ;
  XDrawImageString(dpy, pr[(int) dtype], gc, x, y, str, strlen(str)) ;
  XSetFunction(dpy, gc, GXcopy) ;
}
