
/*  @(#)parsefrom.c 1.2 90/06/20
 *
 *  Returns pointers to the user and host components of an address
 *  described in either a Unix "From " line or an RFC 822 "From:" line.
 *
 *  Copyright (c) Chris Maltby - Softway Ptd Ltd - June 1990.
 *
 *  Permission is given to distribute these sources, as long as the
 *  copyright messages are not removed, and no monies are exchanged. 
 *
 *  No responsibility is taken for any errors inherent either
 *  to the comments or the code of this program, but if reported
 *  to me then an attempt will be made to fix them.
 */

#include <stdio.h>
#include <strings.h>
#include "faces.h"


int
parsefrom(line, userp, hostp)
char *line;
char **userp;
char **hostp;
{
	register char	*p;
	register char	*user;
	register char	*host;

	if (strncmp((user = line), "From ", 5) != 0) {
		if (strncmp(user, "From:", 5) == 0) {
			user += 5;

			while (*user == ' ' || *user == '\t')
				++user;

			/* RFC822 - two formats
			 * From: comment <address>
			 * From: address (comment)
			 */
			if ((p = index(user, '<')) != NULL) {
				user = ++p;
				if ((p = index(user, '>')) != NULL)
					*p = '\0';
				else
					return 0;
			}
			else if ((p = rindex(user, '(')) != NULL) {
				do
					*p = '\0';
				while (*--p == ' ' || *p == '\t');
			}
		}
		else
			return 0;
	} else {
		user += 5;
		while (*user == ' ' || *user == '\t')
			++user;
		if ((p = index(user, ' ')) != NULL)
			*p = '\0';	/* discard date */
	}

	host = NULL;

	/* look for route addresses: @host,addr */
	while (*user == '@') {
		host = ++user;
		if ((p = index(user, ',')) != NULL) {
			*p++ = '\0';
			user = p;
		}
	}
	/* look for '@' */
	while ((p = rindex(user, '@')) != NULL) {
		*p++ = '\0';
		host = p;
	}
	/* now for '%' */
	while ((p = rindex(user, '%')) != NULL) {
		*p++ = '\0';
		host = p;
	}
	/* now for '!' */
	while ((p = index(user, '!')) != NULL) {
		*p++ = '\0';
		host = user;
		user = p;
	}
	if (host == NULL)
		host = "LOCAL";
#ifdef	NODOMAINS
	else if ((p = index(host, '.')) != NULL)
		*p = '\0';
#endif	/* NODOMAINS */
	*hostp = host;
	*userp = user;
	return 1;
}
