
/*  @(#)main.c 1.16 90/06/29
 *
 *  Icon face server for monitoring mail and print jobs.
 *  This program is based on the AT&T v8 mail face server,
 *  vismon, but is not derived from vismon source.
 * 
 *  Copyright (c) Rich Burridge - Sun Microsystems Australia.
 *                                All rights reserved.
 *
 *  Permission is given to distribute these sources, as long as the
 *  copyright messages are not removed, and no monies are exchanged. 
 * 
 *  No responsibility is taken for any errors on inaccuracies inherent
 *  either to the comments or the code of this program, but if reported
 *  to me, then an attempt will be made to fix them.
 */

#include <stdio.h>
#include <strings.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <netdb.h>
#include "faces.h"

unsigned short noface_image[] = {
#include "noface.icon"
} ;

unsigned short nomail_image[] = {
#include "nomail.icon"
} ;
 
unsigned short nopaper_image[] = {
#include "nopaper.icon"
} ;
 
unsigned short noprint_image[] = {
#include "noprint.icon"
} ;
 
unsigned short nousers_image[] = {
#include "nousers.icon"
} ;

char *getname() ;
int do_check() ;
struct recinfo *rec_exists() ;

struct comminfo *communities = NULL ;  /* Community alias/username chain. */
struct comminfo *clast = NULL ;     /* End of chain of community records. */
struct machinfo *machines = NULL ;  /* Known machine/communities. */
struct machinfo *mlast = NULL ;     /* End of chain of machine records. */
struct psinfo *psrecs = NULL ;      /* List of news.ps animation files. */
struct psinfo *plast = NULL ;       /* End of chain of NeWS animation files. */
struct recinfo *recs = NULL ;       /* Mail messages being monitored. */
struct recinfo *last = NULL ;       /* End of the chain of mail records. */
struct stat buf ;                   /* Buffer for file existence stat call. */
long lastsize = 0L ;                /* Last known size of the mail folder. */

enum disp_type wdtype = DISP_NAME ; /* Current window display option. */
enum gr_type gtype ;                /* Which graphics system is being used. */
enum mon_type mtype = MONNEW ;      /* Type of monitoring operation to do. */

char bgicon[MAXLINE] ;           /* Alternate background pattern. */
char community[MAXLINE] ;        /* Community name ("real" host name). */
char defdir[MAXLINE] ;           /* The default face directory. */
char display[MAXLINE] ;          /* X11 display information. */
char *envmail ;             /* Pointer to MAIL environment variable value */
char face_buf[2048] ;       /* Buffer for "X-Face" face images. */
char face_host[MAXLINE] ;   /* Pointer to host name from the "From" line. */
char face_ts[MAXLINE] ;     /* Pointer to time stamp from the "From" line. */
char face_user[MAXLINE] ;   /* Pointer to user name from the "From" line. */
char facedir[MAXLINE] ;          /* Alternate face image directory. */
char fname[MAXTYPES][MAXLINE] ;  /* Array of various face name types. */
char geometry[MAXLINE] ;    /* X11 geometry information. */
char hostname[MAXLINE] ;    /* Machine name to monitor. */
char iconname[MAXLINE] ;    /* Name of the icon file for this person. */
char line[MAXLINE] ;        /* Next line from users mail spool file. */
char machfile[MAXLINE] ;    /* Name of the machine/community file. */
char nextline[MAXLINE] ;    /* Input/conversion buffer for various routines. */
char peopfile[MAXLINE] ;    /* Name of the people/username file. */
char printer[MAXLINE] ;     /* Printer name to monitor. */
char progname[MAXLINE] ;    /* Name of this program. */
char realname[MAXLINE] ;    /* Real username for this user. */
char spoolfile[MAXLINE] ;   /* Full pathname of users current mail. */
char update_alias[MAXLINE] ;   /* Name of mail alias for database updates. */
char *username ;            /* This users name. */
char userprog[MAXLINE] ;    /* User supplied program to run. */

int beeps ;             /* Number of beeps for arrival of new mail. */
int column ;            /* Column number for next icon. */
int doing_xface = 0 ;   /* Set if we've started to process an X-Face: */
int dontshowno = 0 ;    /* Set if number of messages shouldn't be displayed. */
int dontshowtime = 0 ;  /* Set if timestamp for new mail shouldn't be shown. */
int dontshowuser = 0 ;  /* Set if username for new mail shouldn't be shown. */

int facetype ;          /* Type of face file found. */
int firsttime = 1 ;     /* Zeroised after first mail/printer check. */
int flashes ;           /* Number of flashes for arrival of new mail. */
int found ;             /* Set if iconname found under username directory. */
int fromc_found = 0 ;   /* Set if "From:" line found during processing. */
int froms_found = 0 ;   /* Set if "From " line found during processing. */
int height ;            /* Height in pixels of faces display. */

int iconheight = ICONHEIGHT ;  /* Height of an individual icon. */
int iconwidth = ICONWIDTH ;    /* Width of an individual icon. */
int iconic = 0 ;               /* Faces window is closed if set. */
int imageheight = ICONHEIGHT ;  /* Height of an individual face image. */
int imagewidth = ICONWIDTH ;    /* Width of an individual face image. */
int invert = 0 ;               /* Set if to use reverse video. */
int ix = 0 ;                   /* Initial X position of the icon. */
int iy = 0 ;                   /* Initial Y position of the icon. */
int maxcols = NO_PER_ROW ;     /* Maximum number of columns to display. */

int maxtypes ;      /* Maximum number of icon types for graphics target. */
int mhflag = 0 ;    /* Set if this user uses MH to read mail. */
int newmail ;       /* Set if there is new mail this time around. */
int noicons ;       /* Number of faces this time around. */
int old_style = 0 ; /* Set when "old" style face ikon is found. */
int period = 60 ;   /* Period in seconds for new mail check. */
int posspec = 0 ;   /* Set if -Wp or -g option is present (for X11) */
int row ;           /* Row number for next icon. */
int update = 0 ;    /* If set, send mail to update faces database. */
int width ;         /* Width in pixels of faces display. */
int wx = 0 ;        /* Initial X position of the window. */
int wy = 0 ;        /* Initial Y position of the window. */
int x_face = 0 ;    /* Set if we've extracted an "on-the-fly" face. */

/*  256-byte table for quickly reversing the bits in an unsigned 8-bit char,
 *  used to convert between MSBFirst and LSBFirst image formats.
 */

char revtable[256] = {
        0, -128,   64,  -64,   32,  -96,   96,  -32,
       16, -112,   80,  -48,   48,  -80,  112,  -16,
        8, -120,   72,  -56,   40,  -88,  104,  -24,
       24, -104,   88,  -40,   56,  -72,  120,   -8,
        4, -124,   68,  -60,   36,  -92,  100,  -28,
       20, -108,   84,  -44,   52,  -76,  116,  -12,
       12, -116,   76,  -52,   44,  -84,  108,  -20,
       28, -100,   92,  -36,   60,  -68,  124,   -4,
        2, -126,   66,  -62,   34,  -94,   98,  -30,
       18, -110,   82,  -46,   50,  -78,  114,  -14,
       10, -118,   74,  -54,   42,  -86,  106,  -22,
       26, -102,   90,  -38,   58,  -70,  122,   -6,
        6, -122,   70,  -58,   38,  -90,  102,  -26,
       22, -106,   86,  -42,   54,  -74,  118,  -10,
       14, -114,   78,  -50,   46,  -82,  110,  -18,
       30,  -98,   94,  -34,   62,  -66,  126,   -2,
        1, -127,   65,  -63,   33,  -95,   97,  -31,
       17, -111,   81,  -47,   49,  -79,  113,  -15,
        9, -119,   73,  -55,   41,  -87,  105,  -23,
       25, -103,   89,  -39,   57,  -71,  121,   -7,
        5, -123,   69,  -59,   37,  -91,  101,  -27,
       21, -107,   85,  -43,   53,  -75,  117,  -11,
       13, -115,   77,  -51,   45,  -83,  109,  -19,
       29,  -99,   93,  -35,   61,  -67,  125,   -3,
        3, -125,   67,  -61,   35,  -93,   99,  -29,
       19, -109,   83,  -45,   51,  -77,  115,  -13,
       11, -117,   75,  -53,   43,  -85,  107,  -21,
       27, -101,   91,  -37,   59,  -69,  123,   -5,
        7, -121,   71,  -57,   39,  -89,  103,  -25,
       23, -105,   87,  -41,   55,  -73,  119,   -9,
       15, -113,   79,  -49,   47,  -81,  111,  -17,
       31,  -97,   95,  -33,   63,  -65,  127,   -1,
} ;


main(argc, argv)
int argc ;
char *argv[] ;
{
  STRCPY(progname, argv[0]) ;   /* Save this programs name. */
  initialise() ;                /* Set default values for various options. */
  get_options(argc, argv) ;     /* Read and process command line options. */
  read_mailrc() ;               /* Get number of flashes and beeps. */
  read_machines() ;             /* Setup up the machine/community chain. */
  read_aliases() ;              /* Setup the hostname alias subchains. */

  if (init_ws_type(argc, argv)) /* Determine window system type. */
    {
      FPRINTF(stderr,"Error initialising window system.\n") ;
      exit(1) ;
    }

#ifdef REVORDER
  load_icon(NOFACE,  noface_image,  1) ;
  load_icon(NOMAIL,  nomail_image,  1) ;
  load_icon(NOPAPER, nopaper_image, 1) ;
  load_icon(NOPRINT, noprint_image, 1) ;
  load_icon(NOUSERS, nousers_image, 1) ;
#else
  load_icon(NOFACE,  noface_image,  0) ;
  load_icon(NOMAIL,  nomail_image,  0) ;
  load_icon(NOPAPER, nopaper_image, 0) ;
  load_icon(NOPRINT, noprint_image, 0) ;
  load_icon(NOUSERS, nousers_image, 0) ;
#endif /*REVORDER*/
  make_area(DISP_ICON, imagewidth, imageheight) ;

  make_icon() ;                 /* Create default faces icon. */
  make_frame(argc, argv) ;      /* Create faces window/icon. */
  do_check() ;                  /* Generate initial faces display. */
  start_tool() ;                /* Start up and display the faces icon. */
}


a_to_u(community, user, realname)    /* Turn possible alias into username. */
char *community, *user, *realname ;
{
  struct comminfo *ctemp ;
  struct peopinfo *ptemp ;

  STRCPY(realname, user) ;      /* In case alias not found. */
  ctemp = communities ;         /* Point to chain of communities. */
  while (ctemp != NULL)
    if (!strcmp(ctemp->community, community))
      {
        ptemp = ctemp->people ;
        while (ptemp != NULL)
          if (!strcmp(ptemp->alias, user))
            {
              STRCPY(realname, ptemp->username) ;
              return ;
            }
          else ptemp = ptemp->next ;
        return ;
      }
    else ctemp = ctemp->next ;
}


initialise()
{
  STRCPY(facedir, "") ;       /* No alternate face directory by default. */
  STRCPY(display, "") ;       /* X11 display type. */
  STRCPY(geometry, "") ;      /* X11 geometry information. */

#ifdef FBMONTYPE
  mtype = FBMONTYPE ;         /* Type of monitoring to do. */
#endif /*FBMONTYPE*/

#ifdef BACKGROUND
  STRCPY(bgicon, BACKGROUND) ;          /* Alternate background pattern. */
#else
  STRCPY(bgicon, "") ;                  /* Default is to use root gray. */
#endif /*BACKGROUND*/

#ifdef FACEDIR
  STRCPY(defdir, FACEDIR) ;            /* Different directory for face icons. */
#else
  STRCPY(defdir,"/usr/local/faces") ;  /* Directory for face icons. */
#endif /*FACEDIR*/

  SPRINTF(machfile, "%s/%s", defdir, MACHINETAB) ;
  SPRINTF(peopfile, "%s/%s", defdir, PEOPLETAB) ;

#ifdef INVERT
  invert = 1 ;               /* Display in reverse video. */
#endif /*INVERT*/

#ifdef PERIOD
  period = PERIOD ;          /* Period for new mail/print check. */
#endif /*PERIOD*/

#ifdef DONTSHOWNO
  dontshowno = 1 ;           /* Don't show number of messages on images. */
#endif /*DONTSHOWNO*/

#ifdef SPOOLFILE
  STRCPY(spoolfile, SPOOLFILE) ;   /* Alternative spoolfile to monitor. */
#else
  if (envmail = getenv("MAIL")) STRCPY(spoolfile, envmail) ;
  else
    {
      username = getname() ;     /* Get users name from passwd entry. */
      SPRINTF(spoolfile, "/usr/spool/mail/%s", username) ;
    }
#endif /*SPOOLFILE*/

#ifdef UPDATE
  STRCPY(update_alias, UPDATE) ;   /* Alternate faces database update alias. */
#else
  STRCPY(update_alias, UPDATE_ALIAS) ;
#endif /*UPDATE*/

#ifdef DONTSHOWTIME
  dontshowtime = 1 ;           /* Don't show timestamp on images. */
#endif /*DONTSHOWTIME*/

#ifdef DONTSHOWUSER
  dontshowuser = 1 ;           /* Don't show username on images. */
#endif /*DONTSHOWUSER*/
}


h_to_c(host, community)        /* Turn hostname into community name. */
char *host, *community ;
{
  struct hostent *hp ;
  struct machinfo *temp ;      /* Pointer to next machine record. */
 
  temp = machines ;            /* Point to list of machine/communitys. */
  if (host[0] == '\0')
    {
      GETHOSTNAME(community, MAXLINE) ;
      hp = gethostbyname(community) ;
      if (hp != NULL) STRCPY(community, hp->h_name) ;
    }
  else STRCPY(community, host) ;   /* Copied in case machine name not found. */
  while (temp != NULL)
    {
      if (!strcmp(temp->machine, community))
        {
          STRCPY(community, temp->community) ;
          return ;
        }
      temp = temp->next ;      /* Point to next record. */
    }
}


make_iconname(facedir, community, user)    /* Construct the icon name. */
char *facedir, *community, *user ;
{

/*  Sets up community and user based on the first successful
 *  open from the following list of files:
 *
 *  $(FACEDIR)/community/user/[face.ps, sun.icon, 48x48x1, face.xbm]
 *  $(FACEDIR)/misc./user/[face.ps, sun.icon, 48x48x1, face.xbm]
 *  $(FACEDIR)/community/unknown/[face.ps, sun.icon, 48x48x1, face.xbm]
 *  $(FACEDIR)/misc./unknown/[face.ps, sun.icon, 48x48x1, face.xbm]
 *
 *  Firstly a check is made for the "old" style; first in a possible
 *  alternate face directory, then in the default directory. This is
 *  where the username is not a directory but the ikon in 48x48x1
 *  format.
 *
 *  If none of these are found, the "blank face" is returned.
 */

  char *cptr ;
  int i ;

  old_style = 0 ;     /* Reset before checking this face. */

  if (strlen(facedir))
    for (i = -1; i < maxtypes; i++)
      for (cptr = community; cptr != NULL; cptr = index(cptr, '.'))
        {
          if (*cptr == '.') cptr++ ;
          if (i < 0)
            {
              SPRINTF(iconname, "%s/%s/%s", facedir, cptr, user) ;
              if (stat(iconname, &buf) == -1) goto mi1 ;
              if ((buf.st_mode & S_IFMT) == S_IFREG)
                {
                  old_style = 1 ;
                  return 1 ;
                }
            }
          else
            {
              SPRINTF(iconname, "%s/%s/%s/%s", facedir, cptr, user, fname[i]) ;
              if (stat(iconname, &buf) != -1) return 1 ;
            }
        }

mi1:
  for (i = -1; i < maxtypes; i++)
    for (cptr = community; cptr != NULL; cptr = index(cptr, '.'))
      {
        if (*cptr == '.') cptr++ ;
        if (i < 0)
          {
            SPRINTF(iconname, "%s/%s/%s", defdir, cptr, user) ;
            if (stat(iconname, &buf) == -1) goto mi2 ;
            if ((buf.st_mode & S_IFMT) == S_IFREG)
              {    
                old_style = 1 ;
                return 1 ;
              }
          } 
        else
          {
            SPRINTF(iconname, "%s/%s/%s/%s", defdir, cptr, user, fname[i]) ;
            if (stat(iconname, &buf) != -1) return 1 ;
          }
      }
 
mi2:
  if (strlen(facedir))
    for (i = -1; i < maxtypes; i++)
      if (i < 0)
        {
          SPRINTF(iconname, "%s/misc./%s", facedir, user) ;
          if (stat(iconname, &buf) == -1) goto mi3 ;
          if ((buf.st_mode & S_IFMT) == S_IFREG)
            {
              old_style = 1 ;
              return 1 ;
            }
        }    
      else
        { 
          SPRINTF(iconname, "%s/misc./%s/%s", facedir, user, fname[i]) ;
          if (stat(iconname, &buf) != -1)
            {
              if (!x_face) STRCPY(community, "misc.") ;
              return 1 ;
            }
        }

mi3:
  for (i = -1; i < maxtypes; i++)
    if (i < 0)
      {
        SPRINTF(iconname, "%s/misc./%s", defdir, user) ;
        if (stat(iconname, &buf) == -1) goto mi4 ;
        if ((buf.st_mode & S_IFMT) == S_IFREG)
          {
            old_style = 1 ;
            return 1 ;
          }
      }    
    else
      {
        SPRINTF(iconname, "%s/misc./%s/%s", defdir, user, fname[i]) ;
        if (stat(iconname, &buf) != -1)
          {
            if (!x_face) STRCPY(community, "misc.") ;
            return 1 ;
          }
      }
 
mi4:
  if (strlen(facedir))
    for (i = -1; i < maxtypes; i++)
      for (cptr = community; cptr != NULL; cptr = index(cptr, '.'))
        {
          if (*cptr == '.') cptr++ ;
          if (i < 0)
            {
              SPRINTF(iconname, "%s/%s/unknown", facedir, cptr) ;
              if (stat(iconname, &buf) == -1) goto mi5 ;
              if ((buf.st_mode & S_IFMT) == S_IFREG)
                {    
                  old_style = 1 ;
                  return 1 ;
                }
            } 
          else
            {
              SPRINTF(iconname, "%s/%s/unknown/%s", facedir, cptr, fname[i]) ;
              if (stat(iconname, &buf) != -1)
                {
                  if (mtype == MONALL && !x_face) STRCPY(user, "unknown") ;
                  return 1 ;
                }
            }
        }

mi5:
  for (i = -1; i < maxtypes; i++)
    for (cptr = community; cptr != NULL; cptr = index(cptr, '.'))
      {
        if (*cptr == '.') cptr++ ;
        if (i < 0)
          {
            SPRINTF(iconname, "%s/%s/unknown", defdir, cptr) ;
            if (stat(iconname, &buf) == -1) goto mi6 ;
            if ((buf.st_mode & S_IFMT) == S_IFREG)
              {    
                old_style = 1 ;
                return 1 ;
              }
          } 
        else
          {
            SPRINTF(iconname, "%s/%s/unknown/%s", defdir, cptr, fname[i]) ;
            if (stat(iconname, &buf) != -1)
              {
                if (mtype == MONALL && !x_face) STRCPY(user, "unknown") ;
                return 1 ;
              }
          }
      }

mi6:
  if (strlen(facedir))
    for (i = -1; i < maxtypes; i++)
      if (i < 0)
        {
          SPRINTF(iconname, "%s/misc./unknown", facedir) ;
          if (stat(iconname, &buf) == -1) goto mi7 ;
          if ((buf.st_mode & S_IFMT) == S_IFREG)
            {
              old_style = 1 ;
              return 1 ;
            }
        }    
      else
        {
          SPRINTF(iconname, "%s/misc./unknown/%s", facedir, fname[i]) ;
          if (stat(iconname, &buf) != -1)
            {
              if (!x_face) STRCPY(community, "misc.") ;
              if (mtype == MONALL && !x_face) STRCPY(user, "unknown") ;
              return 1 ;
            }
        }

mi7:
  for (i = -1; i < maxtypes; i++)
    if (i < 0)
      {
        SPRINTF(iconname, "%s/misc./unknown", defdir) ;
        if (stat(iconname, &buf) == -1) return 0 ;
        if ((buf.st_mode & S_IFMT) == S_IFREG)
          {
            old_style = 1 ;
            return 1 ;
          }  
      }    
    else
      {
        SPRINTF(iconname, "%s/misc./unknown/%s", defdir, fname[i]) ;
        if (stat(iconname, &buf) != -1)
          {
            if (!x_face) STRCPY(community, "misc.") ;
            if (mtype == MONALL && !x_face) STRCPY(user, "unknown") ;
            return 1 ;
          }
      }

/* Face icon not found, so the "blank face" should be used. */

  return 0 ;
}


read_mailrc()                /* Get number of flashes and beeps. */
{
  char mrcname[MAXLINE] ;    /* Full pathname of the .mailrc file. */
  char *ptr ;
  FILE *fd ;

  beeps = 0 ;     /* Defaults if .mailrc file not found. */
  flashes = 0 ;
  if (getenv("HOME"))
    {
      SPRINTF(mrcname, "%s/.mailrc", getenv("HOME")) ;
      if ((fd = fopen(mrcname, "r")) == NULL) return ;
      while (fgets(nextline, MAXLINE, fd) != NULL)
        if (EQUAL(nextline, "set"))
          {
            ptr = index(nextline, ' ') ;
            if (EQUAL(ptr+1, "flash"))
              {
                ptr = index(nextline, '=') ;
                SSCANF(ptr+1, "%d", &flashes) ;
              }
            else if (EQUAL(ptr+1, "bell"))
              {
                ptr = index(nextline, '=') ;
                SSCANF(ptr+1, "%d", &beeps) ;
              }
          }
    }
  FCLOSE(fd) ;
}
