
/*  @(#)faces.h 1.14 90/06/26
 *
 *  Contains all the global definitions used by faces.
 *
 *  Copyright (c) Rich Burridge - Sun Microsystems Australia.
 *                                All rights reserved.
 *
 *  Permission is given to distribute these sources, as long as the
 *  copyright messages are not removed, and no monies are exchanged. 
 *
 *  No responsibility is taken for any errors or inaccuracies inherent
 *  either to the comments or the code of this program, but if
 *  reported to me then an attempt will be made to fix them.
 */

#define  FCLOSE        (void) fclose      /* To make lint happy. */
#define  FFLUSH        (void) fflush
#define  FGETS         (void) fgets
#define  FPRINTF       (void) fprintf
#define  FPUTS         (void) fputs
#define  FSEEK         (void) fseek
#define  GETHOSTNAME   (void) gethostname
#define  GET_SUN_ICON  (void) get_sun_icon
#define  IOCTL         (void) ioctl
#define  PCLOSE        (void) pclose
#define  PUTC          (void) putc
#define  SELECT        (void) select
#define  SSCANF        (void) sscanf
#define  SPRINTF       (void) sprintf
#define  STRCAT        (void) strcat
#define  STRCPY        (void) strcpy
#define  STRNCAT       (void) strncat
#define  STRNCPY       (void) strncpy
#define  UTIME         (void) utime
#define  WRITE         (void) write

/* Window display types. */
enum disp_type { DISP_NAME,      /* Window type 1. */
                 DISP_OTHER,     /* Window type 2. */
                 DISP_ICON,      /* Icon display. */
                 DISP_BOTH,      /* Both window types. */
                 DISP_ALL,       /* Both window types and the icon. */
} ;

/* Different types of possible face images. */
enum icon_type { BACKGROUND, NOFACE, NOMAIL, NOPAPER,
                 NOPRINT, NOUSERS, ORDINARY, XFACE } ;

enum image_type { ONSCREEN, OLDOFF, CUROFF } ;   /* Image types. */

enum just_type { LEFT, RIGHT } ;                 /* Text justification. */

/* Different types of file monitoring performed by this program. */
enum mon_type { MONALL, MONNEW, MONPRINTER, MONPROG, MONUSERS } ;

/* Different graphics systems. Appropriate one set in gtype. */
enum gr_type { NEWS, SVIEW, X11, XVIEW } ;

/* Determine order for face type lookup. */
#define  NEWSTYPE        0
#define  SUNTYPE         1
#define  BLITTYPE        2
#define  X11TYPE         3

/* NeWS return event values. */
#define  DIED            100  /* Faces has been zapped. */
#define  PAINTED         101  /* Canvas/Icon needs repainting. */
#define  LEFTDOWN        102  /* Left mouse button has been pressed. */

#define  BLITHEIGHT      48       /* Maximum number of lines in a blit icon. */
#define  DEL             '\177'   /* Clear faces display. */
#define  EQUAL(str,val)  !strncmp(str,val,strlen(val))
#define  ICONHEIGHT      64   /* Default height of individual face icons. */
#define  ICONWIDTH       64   /* Default width of individual face icons. */
#define  INC             argc-- ; argv++ ;

#ifndef  LINT_CAST
#ifdef   lint
#define  LINT_CAST(arg)  (arg ? 0 : 0)
#else
#define  LINT_CAST(arg)  (arg)
#endif /*lint*/
#endif /*LINT_CAST*/

#define  MAXICONS        8    /* Maximum number of different icon types. */
#define  MAXITYPES       3    /* Maximum number of image types. */

#ifndef  MAXLINE
#define  MAXLINE         200  /* Maximum length for character strings. */
#endif   MAXLINE

#define  MAXTYPES        4    /* Maximum number of different face types. */
#define  NO_PER_ROW      10   /* Default number of faces per row. */

#ifdef  NOINDEX
#define  index        strchr
#define  rindex       strrchr
#endif /*NOINDEX*/

char *getenv(), *malloc(), *sprintf() ;
void endpwent() ;
FILE *popen() ;

/*  Various programs that are used by faces.
 *  You might need to change these on some machines.
 */

/* Monitoring the printer:        %s replaced by printer name. */
#define  PRINTDEF   "lpq -P %s"

/* Updating the faces database:   %s replaced with mail update alias name. */
#define  UPDATEDEF  "/usr/lib/sendmail -oeq -oi %s"

/* Monitoring users on a machine: %s replaced with hostname. */
#define  USERSDEF   "rusers -l %s"

/* Default definitions used by faces. They can be globally changed here. */

#define  MACHINETAB    "machine.tab"   /* Machine aliases table. */
#define  PEOPLETAB     "people.tab"    /* Username aliases table. */
#define  UPDATE_ALIAS  "facemaker"     /* Faces database update alias. */

struct machinfo                 /* Machine/community record. */
  {
    char *machine ;             /* Machine name. */
    char *community ;           /* Community it belongs to. */
    struct machinfo *next ;     /* Pointer to next record. */
  } ;

struct comminfo                 /* Community alias/username records. */
  {
    char *community ;           /* Community name. */
    struct peopinfo *people ;   /* Chain of alias/usernames. */
    struct comminfo *next ;     /* Pointer to next record. */
  } ;

struct peopinfo                 /* Username/alias record. */
  {
    char *alias ;               /* Alias for this user. */
    char *username ;            /* Real username. */
    struct peopinfo *next ;     /* Pointer to next record. */
  } ;

struct psinfo                   /* News.ps animation records. */
  {
    char *name ;                /* Full pathname of news.ps file. */
    int row ;                   /* Row number where animation will occur. */
    int column ;                /* Column number where animation will occur. */
    struct psinfo *next ;       /* Pointer to next record. */
  } ;

struct recinfo                  /* Mail/print information record. */
  {
    char *community ;           /* Community name for this person. */
    unsigned char *faceimage ;  /* X-Face image or NULL. */
    char *iconname ;            /* Name of iconfile for this person. */
    char *username ;            /* User name for this person. */
    int total ;                 /* Total number of messages/print jobs. */
    int size ;                  /* Total size in bytes of print job. */
    int update ;                /* If set, the database has been updated. */
    char ts[6] ;                /* Latest timestamp for this user. */
    struct recinfo *next ;      /* Pointer to next record. */
  } ;
