
/*  @(#)x11.c 1.12 90/06/26
 *
 *  X11 dependent graphics routines used by faces,
 *  the visual mail and print job monitor.
 * 
 *  Copyright (c) Rich Burridge - Sun Microsystems Australia.
 *                                All rights reserved.
 *
 *  Permission is given to distribute these sources, as long as the
 *  copyright messages are not removed, and no monies are exchanged. 
 * 
 *  No responsibility is taken for any errors or inaccuracies inherent
 *  either to the comments or the code of this program, but if reported
 *  to me, then an attempt will be made to fix them.
 *
 */
 
#include <stdio.h>
#include <sys/time.h>
#include "faces.h"
#include "extern.h"
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
 
#define  DEF_FONT            "fixed"
#define  F_ICON              0         /* Icon index to frame array. */
#define  F_WINDOW            1         /* Window index to frame array. */
#define  FACES_BORDER_WIDTH  2
#define  FONT                "times-roman-10"
#define  FRAME_MASK          (ButtonPressMask  | ExposureMask | \
                              ButtonMotionMask | KeyPressMask)

Atom protocol_atom, kill_atom ;
Display *dpy ;
GC gc ;
GC tilegc ;
Pixmap faces_icon ;

/* Array of the different icon images. */
Pixmap images[MAXICONS] = {
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL
} ;

Pixmap pr[3] = { NULL, NULL, NULL } ;    /* Current memory Pixmaps. */
Pixmap old_pr[2] = { NULL, NULL } ;      /* Previous memory Pixmaps. */
Window frame[2] ;
Window root ;
XFontStruct *sfont ;
XGCValues gc_val ;
XSizeHints size ;
XWMHints wm_hints ;
 
#ifdef NO_43SELECT
int fullmask ;               /* Full mask of file descriptors to check on. */
int readmask ;               /* Readmask used in select call. */
#else
fd_set fullmask ;            /* Full mask of file descriptors to check on. */
fd_set readmask ;            /* Readmask used in select call. */
#endif /*NO_43SELECT*/

unsigned long gc_mask ;
int screen ;
int toclear ;                /* Set if faces icon needs clearing. */
int xfd ;                    /* File descriptor for X11 server connection. */
unsigned int depth ;
long backgnd, foregnd ;
 

adjust_image(dtype, itype, row, column)  /* Put new face in memory pixrect. */
enum disp_type dtype ;
enum icon_type itype ;
int row, column ;
{
  if (mtype == MONNEW)
    XCopyArea(dpy, pr[(int) dtype], pr[(int) dtype], gc, 0, 0,
              (maxcols-1)*imagewidth, imageheight, imagewidth, 0) ;
  XCopyArea(dpy, images[(int) itype], pr[(int) dtype], gc, 0, 0,
            imagewidth, imageheight, column*imagewidth, row*imageheight) ;
}

 
beep_flash(beeps, flashes)    /* Perform visual feedback. */
int beeps, flashes ;
{
  static struct timeval btime = { 0, 250000 } ;   /* Beep timer. */

  while (beeps > 0)
    {
      XBell(dpy, 56) ;
      SELECT(0, (fd_set *) 0, (fd_set *) 0, (fd_set *) 0, &btime) ;
      beeps-- ;
    }
  while (flashes > 0)
    {
      XSetFunction(dpy, gc, GXcopyInverted) ;
      XCopyArea(dpy, frame[F_WINDOW], frame[F_WINDOW], gc, 0, 0,
                (unsigned int) width, (unsigned int) height, 0, 0) ;
      XCopyArea(dpy, frame[F_WINDOW], frame[F_WINDOW], gc, 0, 0,
                (unsigned int) width, (unsigned int) height, 0, 0) ;

      XCopyArea(dpy, frame[F_ICON], frame[F_ICON], gc, 0, 0,
                (unsigned int) width, (unsigned int) height, 0, 0) ;
      XCopyArea(dpy, frame[F_ICON], frame[F_ICON], gc, 0, 0,
                (unsigned int) width, (unsigned int) height, 0, 0) ;
      flashes-- ;
    }
  XSetFunction(dpy, gc, GXcopy) ;
}


create_pixrects(width, height)   /* Create pixrects for the face images. */
int width, height ;
{
  old_pr[(int) DISP_NAME]  = pr[(int) DISP_NAME] ;
  old_pr[(int) DISP_OTHER] = pr[(int) DISP_OTHER] ;

  make_area(DISP_NAME, width, height) ;
  repl_image(DISP_NAME, CUROFF, width, height) ;

  if (toclear && mtype == MONNEW)
    {
      repl_image(DISP_OTHER, OLDOFF, width, height) ;
      toclear = 0 ;
    }
    
  make_area(DISP_OTHER, width, height) ;
  repl_image(DISP_OTHER, CUROFF, width, height) ;
 
  if (mtype == MONNEW && old_pr[(int) DISP_NAME] != NULL)
    XCopyArea(dpy, old_pr[(int) DISP_NAME], pr[(int) DISP_NAME], gc, 0, 0,
              (unsigned int) width, (unsigned int) height, 0, 0) ;
  if (mtype == MONNEW && old_pr[(int) DISP_OTHER] != NULL)
    XCopyArea(dpy, old_pr[(int) DISP_OTHER], pr[(int) DISP_OTHER], gc, 0, 0,
              (unsigned int) width, (unsigned int) height, 0, 0) ;
}


destroy_image(itype)
enum icon_type itype ;
{
  if (images[(int) itype] != NULL)
    {
      XFreePixmap(dpy, images[(int) itype]) ;
      images[(int) itype] = NULL ;
    }
}


init_font()
{
  if ((sfont = XLoadQueryFont(dpy, FONT)) == NULL)
    if ((sfont = XLoadQueryFont(dpy, DEF_FONT)) == NULL)
      {
        perror("couldn't get the default font.") ;
        exit(1) ;
      }
}


/*ARGSUSED*/
init_ws_type(argc, argv)
int argc ;
char *argv[] ;
{
  int i, j ;
  unsigned short buf[256] ;

  if ((dpy = XOpenDisplay(display)) == NULL)
    {
      FPRINTF(stderr,"%s: Couldn't open display %s\n", progname,
              (getenv ("DISPLAY") ? getenv("DISPLAY") : display)) ;
      exit(1) ;
    }
  xfd = ConnectionNumber(dpy) ;

#ifdef NO_43SELECT
  fullmask = 1 << xfd ;
#else
  FD_ZERO(&fullmask) ;
  FD_SET(xfd, &fullmask) ;
#endif /*NO_43SELECT*/

  screen = DefaultScreen(dpy) ;
  root = RootWindow(dpy, screen) ;
  if (geometry[0] != '\0')
    STRCPY(geometry, XGetDefault(dpy, progname, "Geometry")) ;

  foregnd = BlackPixel(dpy, screen) ;
  backgnd = WhitePixel(dpy, screen) ;
  depth = DefaultDepth(dpy, screen) ;

  init_font() ;

  gc_mask = GCFont | GCForeground | GCBackground | GCGraphicsExposures ;
  gc_val.font = sfont->fid ;
  gc_val.foreground = foregnd ;
  gc_val.background = backgnd ;
  gc_val.graphics_exposures = False ;
  gc = XCreateGC(dpy, root, gc_mask, &gc_val) ;
    
  tilegc = XCreateGC(dpy, root, gc_mask, &gc_val) ;
  if (depth == 1) XSetFillStyle(dpy, tilegc, FillOpaqueStippled) ;
  else            XSetFillStyle(dpy, tilegc, FillTiled) ;

  for (i = 0; i < 16; i++)    /* Load default gray background. */
    {
      for (j = 0; j < 4; j++) buf[i * 16      + j] = 0x7777 ;
      for (j = 0; j < 4; j++) buf[i * 16 +  4 + j] = 0xDDDD ;
      for (j = 0; j < 4; j++) buf[i * 16 +  8 + j] = 0xBBBB ;
      for (j = 0; j < 4; j++) buf[i * 16 + 12 + j] = 0xEEEE ;
    }
 
  if (strlen(bgicon)) GET_SUN_ICON(bgicon, buf) ;
  load_icon(BACKGROUND, buf) ;

  STRCPY(fname[0], "face.xbm") ;
  STRCPY(fname[1], "sun.icon") ;
  STRCPY(fname[2], "48x48x1") ;
  maxtypes = 3 ;
  gtype = X11 ;
  pr[(int) DISP_NAME] = pr[(int) DISP_OTHER] = NULL ;
  old_pr[(int) DISP_NAME] = old_pr[(int) DISP_OTHER] = NULL ;
  toclear = 0 ;
  return(0) ;
}


/*ARGSUSED*/
static Bool
is_exposed(dpy, ev, window)   /* Return True if window is being exposed */
Display *dpy ;
XEvent *ev ;
char *window ;
{
  if (ev->type == Expose && *((Window *) window) == ev->xkey.window)
    return True ;
  return False ;
}


/*ARGSUSED*/
load_icon(itype, sbuf, not_flipped)
enum icon_type itype ;
unsigned short sbuf[256] ;
int not_flipped ;
{
  char cbuf[512] ;
  int i ;

  for (i = 0; i < 256; i++)
    {
      cbuf[i*2+0] = revtable[(sbuf[i] >> 8) & 0xFF] ;
      cbuf[i*2+1] = revtable[sbuf[i] & 0xFF] ;
    }
  images[(int) itype] = XCreatePixmapFromBitmapData(dpy, root,
                                           cbuf, iconwidth, iconheight,
                                           foregnd, backgnd, depth) ;
}


make_area(dtype, width, height)
enum disp_type dtype ;
int width, height ;
{
  pr[(int) dtype] = XCreatePixmap(dpy, root,
                      (unsigned int) width, (unsigned int) height, depth) ;
  XSetFunction(dpy, gc, GXandInverted) ;
  XFillRectangle(dpy, pr[(int) dtype], gc, 0, 0, width, height) ;
  XSetFunction(dpy, gc, GXcopy) ;
}


/*ARGSUSED*/
make_frame(argc, argv)
int argc ;
char *argv[] ;
{
  unsigned int h, w ;                /* Window dimensions. */
  int flags ;
  int x, y ;                         /* Window position. */
  XSetWindowAttributes winattrs ;

  w = width = maxcols * imagewidth ;
  h = height = imageheight ;

  size.flags = PMinSize | PMaxSize | PPosition | PSize ;
  size.x = 0 ;
  size.y = 0 ;
  size.min_width = imagewidth ;
  size.min_height = imageheight ;
  size.max_width = size.width = width ;
  if (mtype == MONNEW) size.max_height = imageheight ;
  else                 size.max_height = 900 ;
  size.height = height ;

  if (strlen(geometry))
    {
      flags = XParseGeometry(geometry, &x, &y, &w, &h) ;
      if (XValue & flags)
        {
          if (XNegative & flags)
            x = DisplayWidth(dpy, screen) + x - size.width ;
            size.flags |= USPosition ;
            size.x = x ;
        }
      if (YValue & flags)
        {
          if (YNegative & flags)
            y = DisplayHeight(dpy, screen) + y - size.height ;
            size.flags |= USPosition ;
            size.y = y ;
        }
    }

#ifdef WANTED
  frame[F_WINDOW] = XCreateSimpleWindow(dpy, root,
                                        size.x, size.y, size.width, size.height,
                                        FACES_BORDER_WIDTH, foregnd, backgnd) ;

  frame[F_ICON] = XCreateSimpleWindow(dpy, root,
                                      ix, iy, imagewidth, imageheight,
                                      FACES_BORDER_WIDTH, foregnd, backgnd) ;
#endif /*WANTED*/

  winattrs.background_pixel = backgnd ;
  winattrs.border_pixel = foregnd ;
  winattrs.event_mask = FRAME_MASK ;

  frame[F_WINDOW] = XCreateWindow(dpy, root, size.x, size.y,
                        size.width, size.height, FACES_BORDER_WIDTH,
                        CopyFromParent, InputOutput, CopyFromParent,
                        CWBackPixel | CWBorderPixel | CWEventMask, &winattrs) ;

  frame[F_ICON] = XCreateWindow(dpy, root,
                        ix, iy, imagewidth, imageheight, FACES_BORDER_WIDTH,
                        CopyFromParent, InputOutput, CopyFromParent, 
                        CWBackPixel | CWBorderPixel | CWEventMask, &winattrs) ;

  protocol_atom = XInternAtom(dpy, "WM_PROTOCOLS", False) ;
  kill_atom = XInternAtom(dpy, "WM_DELETE_WINDOW", False) ;
  XSetWMProtocols(dpy, frame[F_WINDOW], &kill_atom, 1) ;

  XSetStandardProperties(dpy, frame[F_WINDOW], "faces", "faces", None,
                         argv, argc, &size) ;
 
  wm_hints.icon_x = ix ;
  wm_hints.icon_y = iy ;
  wm_hints.input = True ;
  wm_hints.icon_window = frame[F_ICON] ;
  wm_hints.flags = IconPositionHint | InputHint | IconWindowHint ;
  if (iconic)
    {    
      wm_hints.initial_state = IconicState ;
      wm_hints.flags |= StateHint ;
    }    
  XSetWMHints(dpy, frame[F_WINDOW], &wm_hints) ;
/**  XSetWMHints(dpy, frame[F_ICON],   &wm_hints) ; **/

/* Equivalent of make_icon. */

  if (mtype == MONPRINTER) adjust_image(DISP_ICON, NOPRINT, 0, 0) ;
  else                     adjust_image(DISP_ICON, NOMAIL,  0, 0) ;
}
 

make_icon()         /* Null routine. */
{}


repl_image(dtype, dest, width, height)
enum disp_type dtype ;
enum image_type dest ;
int width, height ;
{
  Pixmap dpm ;

  if (dest == CUROFF) dpm = pr[(int) dtype] ;
  else dpm = old_pr[(int) dtype] ;
  if (depth == 1) XSetStipple(dpy, tilegc, images[(int) BACKGROUND]) ;
  else XSetTile(dpy, tilegc, images[(int) BACKGROUND]) ;
  XFillRectangle(dpy, dpm, tilegc, 0, 0, width, height) ;
}


show_display()    /* Show the latest set of mail icon faces. */
{
  XEvent ev ;
  static int first_time = 1 ;

  if (invert)     /* Invert the memory pixrects before displaying. */
    {
      XSetFunction(dpy, gc, GXcopyInverted) ;
      XCopyArea(dpy, pr[(int) DISP_NAME], pr[(int) DISP_NAME], gc, 0, 0,
                (unsigned int) width, (unsigned int) height, 0, 0) ;
      XCopyArea(dpy, pr[(int) DISP_OTHER], pr[(int) DISP_OTHER], gc, 0, 0,
                (unsigned int)  width, (unsigned int) height, 0, 0) ;
    }
  if (first_time)
    {
      XSelectInput(dpy, frame[F_WINDOW], FRAME_MASK) ;
      XMapWindow(dpy, frame[F_WINDOW]) ;
      XSync(dpy, 0) ;
      XPeekIfEvent(dpy, &ev, is_exposed, (char *) &frame[F_WINDOW]) ;
      first_time = 0 ;
    }

  XCopyArea(dpy, pr[(int) DISP_ICON], frame[F_ICON], gc, 0, 0,
            (unsigned int) width, (unsigned int) height, 0, 0) ;

  XResizeWindow(dpy, frame[F_WINDOW],
                (unsigned int) width, (unsigned int) height) ;
  XCopyArea(dpy, pr[(int) wdtype], frame[F_WINDOW], gc, 0, 0,
            (unsigned int) width, (unsigned int) height, 0, 0) ;
 
  if (newmail) beep_flash(beeps, flashes) ;
  if (old_pr[(int) DISP_NAME])  XFreePixmap(dpy, old_pr[(int) DISP_NAME]) ;
  if (old_pr[(int) DISP_OTHER]) XFreePixmap(dpy, old_pr[(int) DISP_OTHER]) ;
  old_pr[(int) DISP_NAME] = NULL ;
  old_pr[(int) DISP_OTHER] = NULL ;
  XSync(dpy, 0) ;
}
 

start_tool()
{
  struct timeval tval ;          /* To set checking period. */
  XEvent event ;                 /* For events received. */
  XClientMessageEvent *ev ;
  XKeyPressedEvent *key_event ;
  char chs[2] ;
 
  tval.tv_usec = 0 ;
  tval.tv_sec = period ;

  for (;;)
    {
      readmask = fullmask ;
#ifdef NO_43SELECT
      SELECT(32, &readmask, 0, 0, &tval) ;
      if (readmask && (1 << xfd))
#else
      SELECT(FD_SETSIZE, &readmask, (fd_set *) 0, (fd_set *) 0, &tval) ;
      if (FD_ISSET(xfd, &readmask))
#endif /*NO_43SELECT*/
        do
          {
            XNextEvent(dpy, &event) ;

/* ClientMessage: (catch ICCCM kill from WM). */

            if (event.type == ClientMessage)
              {
                ev = (XClientMessageEvent *) &event ;
                if (ev->message_type == protocol_atom &&
                  ev->data.l[0] == kill_atom)
                exit(0) ;
              }

/* Expose. */

            else if (event.type == Expose && event.xexpose.count == 0)
              {
                while (XCheckTypedEvent(dpy, Expose, &event)) /* do nothing. */ ;
                XCopyArea(dpy, pr[(int) wdtype],
                          frame[F_WINDOW], gc, 0, 0,
                          (unsigned int) width, (unsigned int) height, 0, 0) ;
                XCopyArea(dpy, pr[(int) DISP_ICON],
                          frame[F_ICON], gc, 0, 0,
                          (unsigned int) width, (unsigned int) height, 0, 0) ;
              }

/* ButtonPress. */

            else if (event.type == ButtonPress        &&
                     event.xbutton.button == Button1)
              {
                wdtype = (wdtype == DISP_NAME) ? DISP_OTHER : DISP_NAME ;
                XCopyArea(dpy, pr[(int) wdtype],
                          frame[F_WINDOW], gc, 0, 0,
                          (unsigned int) width, (unsigned int) height, 0, 0) ;
              }

/* KeyPress. */

            else if (mtype == MONNEW && event.type == KeyPress)
              {
                key_event = (XKeyPressedEvent *) &event ;
                (void) XLookupString(key_event, chs, 1, (KeySym *) NULL,
                                     (XComposeStatus *) NULL) ;
                if (chs[0] == DEL)
                  {
                    repl_image(DISP_NAME,  CUROFF, width, height) ;
                    repl_image(DISP_OTHER, CUROFF, width, height) ;
                    toclear = 1 ;
                    do_check() ;
                  }
              }
          }
        while (XPending(dpy)) ;
      else do_check() ;     /* Check the mail/printer/user queue again. */
    }
}
 

text(dtype, jtype, str)
enum disp_type dtype ;
enum just_type jtype ;
char *str ;
{
  int len ;
  int c, r ;         /* Column and row position for this face. */
  int x, y ;         /* Position of start of this text string. */
 
  c = column ;
  r = row ;
  switch (dtype)
    {
      case DISP_ALL    : text(DISP_ICON,  jtype, str) ;
      case DISP_BOTH   : text(DISP_NAME,  jtype, str) ;
                         text(DISP_OTHER, jtype, str) ;
                         return ;
      case DISP_ICON   : c = r = 0 ;
    }
 
  if ((len = strlen(str)) > 10)     /* Character length of text. */
    {
      len = 10 ;
      str[10] = '\0' ;              /* Maximum of 10 characters. */
    }
  switch (jtype)
    {
      case LEFT  : x =  c      * imagewidth + 2 ;
                   y = (r + 1) * imageheight - 5 ;
                   break ;
      case RIGHT : x = (c + 1) * imagewidth - (len * 6) - 2 ;
                   y = (r + 1) * imageheight - 5 ;
    }
  XSetFunction(dpy, gc, GXandInverted) ;
  XFillRectangle(dpy, pr[(int) dtype], gc, x, y-9, (unsigned int) len*6+2, 13) ;
  XSetFunction(dpy, gc, GXxor) ;
  XDrawImageString(dpy, pr[(int) dtype], gc, x, y, str, strlen(str)) ;
  XSetFunction(dpy, gc, GXcopy) ;
}
