
/*  @(#)rec.c 1.10 90/06/26
 *
 *  Record handling routines used by the faces program.
 * 
 *  Copyright (c) Rich Burridge - Sun Microsystems Australia.
 *                                All rights reserved.
 *
 *  Permission is given to distribute these sources, as long as the
 *  copyright messages are not removed, and no monies are exchanged. 
 * 
 *  No responsibility is taken for any errors on inaccuracies inherent
 *  either to the comments or the code of this program, but if reported
 *  to me, then an attempt will be made to fix them.
 */

#include <stdio.h>
#include <strings.h>
#include "faces.h"
#include "extern.h"


char *
Malloc(n)
int n ;
{
  char *val ;

  if ((val = malloc((unsigned) n)) == NULL)
    FPRINTF(stderr, "%s: Out of memory.\n", progname) ;
  return val ;
}


add_alias(crec, username, alias)  /* Add new alias to hostnames' list. */
struct comminfo *crec ;
char *username, *alias ;
{
  struct peopinfo *cptemp, *ptemp ;

  ptemp = (struct peopinfo *) LINT_CAST(Malloc(sizeof(struct peopinfo))) ;
  ptemp->alias = (char *) Malloc(strlen(alias)+1) ;
  STRCPY(ptemp->alias, alias) ;
  ptemp->username = (char *) Malloc(strlen(username)+1) ;
  STRCPY(ptemp->username, username) ;
  ptemp->next = NULL ;

  if (crec->people == NULL) crec->people = ptemp ;
  else
    {
      cptemp = crec->people ;
      while (cptemp != NULL)
        if (cptemp->next == NULL)
          {
            cptemp->next = ptemp ;
            return ;
          }
        else cptemp = cptemp->next ;
    }
}


add_machine(machine, community)    /* Add new machine to list. */
char *machine, *community ;
{
  struct machinfo *temp ;

  temp = (struct machinfo *) LINT_CAST(Malloc(sizeof(struct machinfo))) ;
  temp->machine = (char *) Malloc(strlen(machine)+1) ;
  STRCPY(temp->machine, machine) ;
  temp->community = (char *) Malloc(strlen(community)+1) ;
  STRCPY(temp->community, community) ;
  temp->next = NULL ;

  if (machines == NULL) machines = mlast = temp ;   /* Start chain. */
  else if (mlast != NULL)
    {
      mlast->next = temp ;     /* Add record to existing chain. */
      mlast = temp ;           /* Point to end of chain. */
    }
}


add_ps_rec(row, column, name)  /* Add record for later animation. */
int row, column ;
char *name ;
{
  struct psinfo *temp ;

  temp = (struct psinfo *) LINT_CAST(Malloc(sizeof(struct psinfo))) ;
  temp->name = (char *) Malloc(strlen(name)+1) ;
  STRCPY(temp->name, name) ;
  temp->row = row ;
  temp->column = column ;
  temp->next = NULL ;

  if (psrecs == NULL) psrecs = plast = temp ;    /* Start chain. */
  else if (plast != NULL)
    {
      plast->next = temp ;     /* Add record to existing chain. */
      plast = temp ;
    }
}


add_record(community, username, timestamp, size)
char *community, *username, *timestamp ;
int size ;
{
  struct recinfo *temp ;

  temp = (struct recinfo *) LINT_CAST(Malloc(sizeof(struct recinfo))) ;
  temp->community = (char *) Malloc(strlen(community)+1) ;
  STRCPY(temp->community, community) ;
  temp->username = (char *) Malloc(strlen(username)+1) ;
  STRCPY(temp->username, username) ;
  temp->iconname = (char *) Malloc(strlen(iconname)+1) ;
  STRCPY(temp->iconname, iconname) ;
  if (x_face)
    {
      temp->faceimage = (unsigned char *) Malloc(strlen(face_buf)+1) ;
      STRCPY(temp->faceimage, face_buf) ;
    }
  else temp->faceimage = NULL ;
  STRCPY(temp->ts, timestamp) ;
  temp->size = size ;
  temp->total = 1 ;
  temp->update = 0 ;
  temp->next = NULL ;
  noicons++ ;
  if (recs == NULL) recs = last = temp ;        /* Start chain. */
  else
    {
      last->next = temp ;  /* Add record to existing chain. */
      last = temp ;        /* Point to the end of the chain. */
    }
}


check_comm(hostname, username, alias)  /* Check community list. */
char *hostname, *username, *alias ;
{
  struct comminfo *ctemp ;
 
  ctemp = communities ;      /* Try and find machine record for hostname. */
  while (ctemp != NULL)
    if (!strcmp(ctemp->community, hostname))
      {  
        add_alias(ctemp, username, alias) ;
        return ;
      }  
    else ctemp = ctemp->next ;
 
  ctemp = (struct comminfo *) LINT_CAST(Malloc(sizeof(struct comminfo))) ;
  ctemp->community = (char *) Malloc(strlen(hostname)+1) ;
  STRCPY(ctemp->community, hostname) ; 
  ctemp->people = NULL ; 
  ctemp->next = NULL ; 
 
  if (communities == NULL) communities = clast = ctemp ;  /* Start chain. */ 
  else 
    { 
      clast->next = ctemp ;   /* Add record to existing chain. */
      clast = ctemp ;         /* Point to end of chain. */
    }
  add_alias(ctemp, username, alias) ;
}


/* Remove records with zero count; zeroise count for others. */

garbage_collect()
{
  struct recinfo *last, *this, *next ;

  last = NULL ;
  this = recs ;
  while (this != NULL)
    {
      next = this->next ;
      if (!this->total)
        {
          if (last != NULL) last->next = this->next ;
          if (this == recs) recs = this->next ;
          remove_record(this) ;
        }
      else
        {
          this->total = 0 ;
          last = this ;
        }
      this = next ;
    }
}


read_aliases()     /* Setup the hostname aliases subchains. */
{
  char alias[MAXLINE] ;      /* Alias for this community/username. */
  char hostname[MAXLINE] ;   /* This records' hostname. */
  char username[MAXLINE] ;   /* This records real username. */
  char *ptr1, *ptr2 ;
  FILE *fd ;

  if (strlen(facedir)) SPRINTF(peopfile, "%s/PEOPLETAB", facedir) ;
  if ((fd = fopen(peopfile, "r")) == NULL)   /* Open people file. */
    {
      if (strlen(facedir))
        {
          SPRINTF(peopfile, "%s/machine.tab", defdir) ;
          fd = fopen(peopfile, "r") ;
        }
      if (fd == NULL)
        {
          FPRINTF(stderr,"%s: cannot open %s\n", progname, peopfile) ;
          return ;
        }
    }
  while (fgets(nextline, MAXLINE, fd) != NULL)
    {
      if (nextline[0] == '\n' || nextline[0] == '#') continue ;
      ptr1 = index(nextline, '/') ;
      if (((int) (ptr1-nextline)) <= 0) continue ;  /* Ignore if no length. */
      STRNCPY(hostname, nextline, (int) (ptr1-nextline)) ;
      hostname[(int) (ptr1-nextline)] = '\0' ;
      ptr2 = index(nextline, '=') ;
      if (((int) (ptr2-ptr1-1)) <= 0) continue ;    /* Ignore if no length. */
      STRNCPY(alias, ptr1+1, (int) (ptr2-ptr1-1)) ;
      alias[(int) (ptr2-ptr1-1)] = '\0' ;
      if ((strlen(ptr2)-2) <= 0) continue ;         /* Ignore if no length. */
      STRNCPY(username, ptr2+1, strlen(ptr2)-2) ;
      username[strlen(ptr2)-2] = '\0' ;
      check_comm(hostname, username, alias) ;
    }
  FCLOSE(fd) ;
}


read_machines()       /* Setup the chain of machine/community records. */
{
  char community[MAXLINE] ;   /* This records' community. */
  char machine[MAXLINE] ;     /* This records' machine name. */
  char *ptr ;
  FILE *fd ;

  if (strlen(facedir)) SPRINTF(machfile, "%s/MACHINETAB", facedir) ;
  if ((fd = fopen(machfile, "r")) == NULL)   /* Open machine file. */
    {
      if (strlen(facedir))
        {
          SPRINTF(machfile, "%s/machine.tab", defdir) ;
          fd = fopen(machfile, "r") ;
        }
      if (fd == NULL)
        {
          FPRINTF(stderr,"%s: cannot open %s\n", progname, machfile) ;
          return ;
        }
    }
  while (fgets(nextline, MAXLINE, fd) != NULL)
    {
      if (nextline[0] == '\n' || nextline[0] == '#') continue ;
      ptr = index(nextline, '=') ;
      if (((int) (ptr-nextline)) <= 0) continue ;  /* Ignore if no length. */
      STRNCPY(machine, nextline, (int) (ptr-nextline)) ;
      machine[(int) (ptr-nextline)] = '\0' ;
      if (strlen(ptr)-2 <= 0) continue ;           /* Ignore if no length. */
      STRNCPY(community, ptr+1, strlen(ptr)-2) ;
      community[strlen(ptr)-2] = '\0' ;
      add_machine(machine, community) ;
    }
  FCLOSE(fd) ;
}


struct recinfo *
rec_exists(community,username)    /* Check if record exists for mail item. */
char *community, *username ;
{
  struct recinfo *temp ;     /* Pointer to mail records used for chaining. */

  temp = recs ;
  while (temp != NULL)
    {
      if (!strcmp(temp->username, username) &&
          !strcmp(temp->community, community))
        return(temp) ;       /* Record found. */
      temp = temp->next ;    /* Point to next record. */
    }
  return(NULL) ;
}


remove_record(thisrec)        /* Remove this record from the chain. */
struct recinfo *thisrec ;
{
  if (thisrec->community != NULL) free(thisrec->community) ;
  if (thisrec->faceimage != NULL) free(thisrec->faceimage) ;
  if (thisrec->username  != NULL) free(thisrec->username) ;
  if (thisrec->iconname  != NULL) free(thisrec->iconname) ;
  free((char *) thisrec) ;
}
