/* xc
% cc -O echo.c -o echo
% strip echo
 */
/*
 * echo - echo arguments
 * Usage: echo [-n] [string...]
 *
 * If the first argument is "-n", the trailing newline is omitted.
 * The "-n" is not echoed.
 *
 * Recognizes System V escape sequences:
 * \0ooo	octal ASCII character (1-3 digits)
 * \b		backspace
 * \c		omit trailing newline; don't print anything more (same as -n)
 * \f		form feed
 * \n		newline (line feed)
 * \r		carriage return
 * \t		horizontal tab
 * \v		vertical tab
 * \\		backslash
 *
 * David MacKenzie
 * Latest revision: 08/07/88
 */

#include <stdio.h>

main(argc, argv)
    int             argc;
    char          **argv;
{
    void            echo();
    register int    optind;

    for (optind = 1; optind < argc; ++optind)
	if (optind != 1 || strcmp(argv[optind], "-n")) {
	    echo(argv[optind]);
	    if (optind < argc - 1)
		putchar(' ');
	}
    if (argc == 1 || strcmp(argv[1], "-n"))
	putchar('\n');

    exit(0);
}

void
echo(s)
    register char  *s;
{
    register int    i,		/* Digit counter for octal numbers. */
                    n;		/* Value of octal numbers. */

    for (; *s; ++s) {
	if (*s != '\\')
	    putchar(*s);
	else
	    switch (*++s) {
	    case 0:
		putchar('\\');
		return;
	    case '\\':
		putchar('\\');
		break;
	    case '0':
		for (i = n = 0, ++s; i < 3 && *s >= '0' && *s <= '7'; ++i, ++s)
		    n += *s - '0';
		--s;
		putchar(n);
		break;
	    case 'b':
		putchar(8);
		break;
	    case 'c':
		exit(0);
	    case 'f':
		putchar(12);
		break;
	    case 'n':
		putchar('\n');
		break;
	    case 'r':
		putchar('\r');
		break;
	    case 't':
		putchar('\t');
		break;
	    case 'v':
		putchar(11);
		break;
	    default:
		putchar('\\');
		putchar(*s);
		break;
	    }
    }
}
