/* RCS      -- $Header: /u2/dvadura/src/generic/dmake/src/common/RCS/alloc.h,v 1.1 90/10/06 12:04:39 dvadura Exp $
-- SYNOPSIS -- macros for allocating memory.
-- 
-- DESCRIPTION
--	A somewhat nicer interface to malloc and calloc.
--	Here we standardise the calling convention with a common macro
--	interface.
-- 
-- AUTHOR
--      Dennis Vadura, dvadura@watdragon.uwaterloo.ca
--      CS DEPT, University of Waterloo, Waterloo, Ont., Canada
--
-- COPYRIGHT
--      Copyright (c) 1990 by Dennis Vadura.  All rights reserved.
-- 
--      This program is free software; you can redistribute it and/or
--      modify it under the terms of the GNU General Public License
--      (version 1), as published by the Free Software Foundation, and
--      found in the file 'LICENSE' included with this distribution.
-- 
--      This program is distributed in the hope that it will be useful,
--      but WITHOUT ANY WARRANTY; without even the implied warrant of
--      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--      GNU General Public License for more details.
-- 
--      You should have received a copy of the GNU General Public License
--      along with this program;  if not, write to the Free Software
--      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
--
-- LOG
--     $Log:	alloc.h,v $
 * Revision 1.1  90/10/06  12:04:39  dvadura
 * dmake Release, Version 3.6
 * 
*/

#ifndef ALLOC_h
#define ALLOC_h

/* DO NOT CHANGE these!  These are the definitions that the make source
 * uses for allocating memory.  They must be defined for make to compile
 * properly.
 */

#if !defined(_TYPES_) && !defined(M_XENIX)
#if defined(MSDOS) || defined(__MSDOS__)
typedef unsigned size_t;
#else
typedef long size_t;
#endif
#endif

#define	usizeof(t)	(size_t)sizeof(t)

#ifdef	DBUG
#define FREE(p)         My_free((char*)(p), __FILE__, __LINE__)
#define MALLOC(n, t)    (t*) My_malloc((n)*usizeof(t),  __FILE__, __LINE__)
#define CALLOC(n, t)    (t*) My_calloc((n), usizeof(t), __FILE__, __LINE__)
#else
#define FREE(p)         free((char*)(p))
#define MALLOC(n, t)    (t*) malloc((unsigned int)(n)*usizeof(t))
#define CALLOC(n, t)    (t*) calloc((unsigned int)(n), usizeof(t))
#endif

#define TALLOC(p, n, t)	if ((p = CALLOC(n, t)) == (t*)0) {No_ram();}

#endif

