# This is the MSC 4.0 and higher DOS configuration file for DMAKE
#	It simply modifies the values of SRC, and checks to see if
#	OSENVIRONMENT is defined.  If so it includes the appropriate
#	config.mk file.
#
# It also sets the values of .SOURCE.c and .SOURCE.h to include the local
# directory.
#
osrdir := $(OS)$(DIRSEPSTR)$(OSRELEASE)

TMPDIR :=
.EXPORT : TMPDIR

# Definition of macros for library, and C startup code.

# The following sources are required for MSC
OSR_SRC = tempnam.c
.SETDIR=$(osrdir) : $(OSR_SRC)

SRC += $(OSR_SRC)
.SOURCE.h : $(osrdir)

# Local configuration modifications for CFLAGS, there's local BSD includes
# too.
# If you have a 286, you can use -G2 or appropriate to get better code, 
# in that case uncomment the line below.
#CFLAGS += -G2
CFLAGS += -I$(osrdir) -D__STDC__=1 -DM_I86=1 $(C_$(MODEL))
ASFLAGS += -t -mx $(S_$(MODEL))

# Redefine this, it isn't needed!
LDTAIL = ;

# Debugging Flags
DB_CFLAGS     += -Zi
DB_LDFLAGS    += /co /li /map
DB_LDLIBS     +=

# NO Debug flags, MSC 6.0 flags, set the environment variable MSC_VER to be
# 6.0 to get these by default when you make dmake using 'dmake'.
.IMPORT .IGNORE : MSC_VER
.IF $(MSC_VER) == 6.0
   NDB_CFLAGS    += -Osecgle -Gs -D_MSC60_
   DB_CFLAGS     += -D_MSC60_
   NDB_LDFLAGS   += /exe /packc /batch
   NDB_LDLIBS    +=
.ELSE
   NDB_CFLAGS    += -Zp
   DB_CFLAGS     += -Zp
.END

# See if we modify anything in the lower levels.
.IF $(OSENVIRONMENT) != $(NULL)
   .INCLUDE .IGNORE : $(osrdir)$(DIRSEPSTR)$(OSENVIRONMENT)$(DIRSEPSTR)config.mk
.END

C_s =
C_m = -mm
C_c = -mc
C_l = -ml

S_s = -Dmsmall
S_m = -Dmmedium
S_c = -Dmcompact
S_l = -Dmlarge
