/* RCS      -- $Header: /u2/dvadura/src/generic/dmake/src/RCS/function.c,v 1.1 90/10/06 12:04:36 dvadura Exp $
-- SYNOPSIS -- GNU style functions for dmake.
-- 
-- DESCRIPTION
-- 	All GNU stule functions understood by dmake are implemented in this
--	file.  Currently the only such function is $(mktmp ...) which is
--	not part of GNU-make is an extension provided by dmake.
--
-- AUTHOR
--      Dennis Vadura, dvadura@watdragon.uwaterloo.ca
--      CS DEPT, University of Waterloo, Waterloo, Ont., Canada
--
-- COPYRIGHT
--      Copyright (c) 1990 by Dennis Vadura.  All rights reserved.
-- 
--      This program is free software; you can redistribute it and/or
--      modify it under the terms of the GNU General Public License
--      (version 1), as published by the Free Software Foundation, and
--      found in the file 'LICENSE' included with this distribution.
-- 
--      This program is distributed in the hope that it will be useful,
--      but WITHOUT ANY WARRANTY; without even the implied warrant of
--      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--      GNU General Public License for more details.
-- 
--      You should have received a copy of the GNU General Public License
--      along with this program;  if not, write to the Free Software
--      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
--
-- LOG
--     $Log:	function.c,v $
 * Revision 1.1  90/10/06  12:04:36  dvadura
 * dmake Release, Version 3.6
 * 
*/

#include "extern.h"
#include "alloc.h"

static char *_exec_mktmp ANSI((char *, char *));


char *
Exec_function(buf)/*
====================
   Execute the function given by the value of args.

   So far mktmp is the only valid function, anything else elicits and error
   message.  It is my hope to support the GNU style functions in this portion
   of the code at some time in the future. */
char *buf;
{
   char *fname;
   char *args = NIL(char);
   char *mod  = NIL(char);
   char *res  = NIL(char);

   /* This must succeed since the presence of ' ', \t or \n is what
    * determines if this functions is called in the first place. */
   fname = _substr(buf, args=_strpbrk(buf," \t\n"));

   if( (mod = strchr(fname,',')) != NIL(char) ){
      *mod = '\0';
      mod++;
   }

   switch( *fname ) {
      case 'm':
	 if( strncmp(fname,"mktmp", 5) == 0 ) res = _exec_mktmp(mod, args);
	 break;
   }

   if( res == NIL(char) ) {
      Warning( "Function '%s' not implemented at this time", fname );
      res = _strdup("");
   }

   return(res);
}


static char *
_exec_mktmp( mod, data )
char *mod;
char *data;
{
   register char *p;
   char *tmpname;
   FILE *tmpfile;
   char *name;

   tmpfile = Start_temp( "", Recipe_cell, Recipe_how, &tmpname );
   data    = Expand(_strspn(data, " \t\n"));
   name    = Recipe_cell ? Recipe_cell->CE_NAME:"makefile text";

   for(p=strchr(data,'\n'); p; p=strchr(p,'\n')) {
      char *q = _strspn(++p," \t");
      strcpy(p,q);
   }

   Append_line( data, FALSE, tmpfile, name, FALSE, TRUE );
   Close_temp( Recipe_how, tmpfile );
   FREE(data);

   return( (mod != NIL(char) && *mod) ? Expand(mod) : _strdup(tmpname) );
}
