# Make a listing of either everything so far, or just the stuff that has
# been updated since the last time a printout was made.
# The targets are:
#	print		- to print only updated files.
#	printall	- to print entire tree.
#
# MACROS are:
#	PRINTER		- printer name on which to put output, output
#			  goes to a file if no printer name is given.
#	PRINTFLAGS	- flags to pass to the printer.
#	PRINTEXCLUDE	- substrings in file names not to include in output.

GROUPFLAGS  :=
SEDLIST = _sed_e_flag_'/{ $(PRINTEXCLUDE) }/d'
FILIST  = $(TMPDIR)/pr$$$$
OFILE   = $(TMPDIR)/pr$$$$.out

.IF $(PRINTEXCLUDE)
   SEDARGS = $(SEDLIST:s/_sed_e_flag_/-e /)
.END

printall : print_remove_ctl print;
print_remove_ctl:;@-$(RM) control/print

print:
@[
   if [ -f control/print ]; then
      find . -type f -newer control/print -print |\
      sort -t. +2 +1 -2 |\
      sed $(SEDARGS) >$(FILIST);
      if [ -s $(FILIST) ]; then
	 find . -type f -print | sort -t. +2 +1 -2 |\
	 sed $(SEDARGS) >$(FILIST).full;
	 cpr -c -T control/title -N -C `cat $(FILIST).full` >$(OFILE);
	 cpr -c -N `cat $(FILIST)` >> $(OFILE);
	 $(RM) $(FILIST).full;
      else
	 echo "No modified files since last printing";
      fi
   else
      find . -type f -print | sort -t. +2 +1 -2 |\
      sed $(SEDARGS) >$(FILIST);
      if [ -s $(FILIST) ]; then
	 cpr -c -T control/title -N `cat $(FILIST)` >$(OFILE);
      fi
   fi

   if [ -s $(OFILE) ]; then
.IF $(PRINTER)
      $(PRINT) $(PRINTFLAGS) $(OFILE);
      echo "Listing printed on $(PRINTER)";
.IF $(PRINTKEEPTMP) == $(NULL)
      $(RM) $(OFILE);
.END
.ELSE
      echo "Listing can be temporarily found in $(OFILE)";
.END
   fi
.IF $(PRINTKEEPTMP) == $(NULL)
   $(RM) $(FILIST)
.END
   touch control/print;
   exit 0
]
