#include <stdio.h>
#include <ctype.h>

char tbuf[BUFSIZ * 16];		/* really big */
char *input ();
FILE *fp;
int verbose = 0;

main (argc, argv)
int argc;
char **argv;
{
	verbose = (argc > 1);

	while (input (tbuf) != NULL)
	{
		if (tbuf[0] == '#')
			comment ();
		else
			entry ();
	}
}

int usebuf = 0;

char *input (bp)
char *bp;
{
	if (! usebuf)
		return (gets (bp));
	else
	{
		usebuf = 0;
		return (tbuf);
	}
}

comment ()
{
	static int com_no = 1;
	char name[20];

	sprintf (name, "comment.%d", com_no++);
	if ((fp = fopen (name, "w")) == NULL)
	{
		fflush (stdout);
		fprintf (stderr, "%s: could not open\n", name);
		exit (1);
	}

	do
	{
		fprintf (fp, "%s\n", tbuf);
		if (input (tbuf) == NULL)
		{
			fclose (fp);
			exit (0);
		}
	} while (tbuf[0] == '#');

	/* at this point, a non-comment is in the buffer */
	usebuf = 1;
	fclose (fp);
}

char *getname ();
char *getentry ();

entry ()
{
	int end = strlen (tbuf) - 1;
	char *name, *fullname, *cp, *state;
	char *index ();

	/* first, get the entire entry */
	while (tbuf[end] == '\\')
	{
		if (input (& tbuf[end]) == NULL)
		{
			fflush (stdout);
			fprintf (stderr, "stdin ended with a '\\\\'\n");
			exit (1);
		}
		end = strlen (tbuf) - 1;
	}
	/* now pull it apart */

	state = tbuf;
	fullname = getentry (& state);
	name = getname (fullname);

	if (verbose)
		printf ("%s\n", name);

	dodir (name);

	if ((fp = fopen (name, "w")) == NULL)
	{
		fflush (stdout);
		fprintf (stderr, "%s: could not open\n", name);
		exit (1);
	}
	fprintf (fp, "%s\n", fullname);
	fclose (fp);

	while (cp = getentry (& state))
		doentry (cp);

	if (chdir ("..") < 0)
	{
		perror ("chdir(\"..\")");
		exit (1);
	}
}

char *getname (cp)
register char *cp;
{
	static char shortname[100];
	register int i = 0;

	while (*cp != '|')
		cp++;

	for (cp++; *cp != '|' && *cp != ':'; cp++)
		shortname[i++] = *cp;
	shortname[i] = '\0';

	return (shortname);
}

char *getentry (state)
register char **state;
{
	char *cp;

	if (!state || ! *state || ! **state)
		return (NULL);

	while (**state == '\t' || **state == ':')
		(*state)++;

	cp = *state;

	while (**state && **state != ':')
		(*state)++;

	**state = '\0';
	(*state)++;

	if (verbose)
		printf ("\t'%s'\n", cp);

	return (cp);
}

dodir (dir)
char *dir;
{
	char buf[100];

	if (mkdir (dir, 0755) < 0)
	{
		sprintf (buf, "mkdir (\"%s\")", dir);
		perror (buf);
		exit (1);
	}
	if (chdir (dir) < 0)
	{
		sprintf (buf, "chdir (\"%s\")", dir);
		perror (buf);
		exit (1);
	}
}

doentry (cp)
char *cp;
{
	char name[3];

	name[0] = cp[0];
	name[1] = cp[1];
	name[2] = '\0';

	if ((fp = fopen (name, "w")) == NULL)
	{
		fflush (stdout);
		fprintf (stderr, "%s: could not open\n", name);
		exit (1);
	}

	fprintf (fp, "%s\n", cp);
	fclose (fp);
}

#ifdef	NEED_MKDIR_SUB
int
mkdir(p, u)
    char	*p;
    int		 u;
{
    char	 buff[BUFSIZ];

    /* By playing with UMASK you can skip the chmod, but so it goes. */
    (void)sprintf(buff, "mkdir %s && chmod %o %s", p, u, p);
    return(system(buff) ? -1 : 0);
}
#endif	/* NEED_MKDIR_SUB */
