/*
 * cvtbase -- convert from one base to another.  Usage:
 *
 * cvtbase input-base-spec output-base-spec < input > output
 *
 * where a base spec is one of:
 *
 *	d
 *	D	Specifies "decimal" -- digits 0 through 9
 *
 *	x
 *	h	Specifies "hexadecimal" -- digits 0-9 and a-f
 *
 *	X
 *	H	Specifies "Hexadecimal" -- digits 0-9 and A-F
 *
 *	o
 *	O	Specifies "octal" -- digits 0 through 7
 *
 *	b
 *	B	Specifies "binary" -- digits 0 and 1
 *
 * or a string of two or more characters, which are the digits (eg. 012 would
 *  use ternary notation).  Any of these may be preceded by a - sign to
 *  indicate that the base in question is negative.  A leading + sign is
 *  stripped; to enter a string of digits beginning with a + or - sign, you
 *  must precede the string with a + or - sign (depending on whether you want
 *  a positive or negative base).
 *
 * Any base specifier may be preceded by an m (or an M) and one other
 *  character to change the minus sign (the default is of course -).
 *
 * For a minus sign to be recognized in the input, it must be immediately
 *  followed by the number.  If anything (such as a space) intervenes, the
 *  minus sign will be echoed and ignored (as if it were an ordinary
 *  character).
 *
 * Bases -1, 0, and 1 are disallowed.
 *
 * Input is taken from the standard input; the converted output appears
 *  on the standard output.
 *
 * Copyright 1988 by Mike Parker.  All rights reserved.  Non-profit
 *  redistribution permitted.
 */
#include <stdio.h>

/* extern */ char **argvec;

static int errs;

static int indig;
static char *idigits;
static char isign;
static int ondig;
static char *odigits;
static char osign;

char *index();

long int get_number(ndig,digits,sign)
int ndig;
char *digits;
char sign;
{
 long int retval;
 int minus;
 char c;
 char *cp;

 retval = 0;
 minus = 1;
 while (1)
  { c = getchar();
    if (feof(stdin))
     { if (minus < 0)
	{ putchar(sign);
	  minus = 1;
	}
       exit(0);
     }
    if ((cp=index(digits,c)) != 0)
     { break;
     }
    if ((c == sign) && (ndig > 0))
     { minus = - minus;
     }
    else
     { if (minus < 0)
	{ putchar(sign);
	  minus = 1;
	}
       putchar(c);
     }
  }
 while (1)
  { retval *= ndig;
    retval += (cp-digits);
    c = getchar();
    if (feof(stdin))
     { break;
     }
    if ((cp=index(digits,c)) == 0)
     { break;
     }
  }
 ungetc(c,stdin);
 return(minus*retval);
}

put_number(ndig,digits,sign,value)
int ndig;
char *digits;
char sign;
long int value;
{
 if ((value < 0) && (ndig > 0))
  { putchar(sign);
    value = - value;
  }
 _put_number(ndig,digits,value);
}

_put_number(ndig,digits,value)
int ndig;
char *digits;
long int value;
{
 long int i;
 int j;

 i = value / ndig;
 j = value % ndig;
 if (j < 0)
  { j -= ndig;
    i ++;
  }
 if (i != 0)
  { _put_number(ndig,digits,i);
  }
 putchar(digits[j]);
}

get_base(arg,Ndig,Digits,Sign)
char *arg;
int *Ndig;
#define ndig (*Ndig)
char **Digits;
#define digits (*Digits)
char *Sign;
#define sign (*Sign)
{
 int isneg;
 char *origarg = arg;

 sign = '-';
 isneg = 0;
 if ((*arg == 'm') || (*arg == 'M'))
  { sign = *++arg;
    if (sign == '\0')
     { fprintf(stderr,"%s: %c must be followed by a sign character\n",
			argvec[0],arg[-1]);
       errs = 1;
       return;
     }
    arg ++;
  }
 if ((*arg == '+') || (*arg == '-'))
  { isneg = (*arg++ == '-');
  }
 switch (*arg++)
  { case 'b': case 'B':
       digits = "01";
       break;
    case 'o': case 'O':
       digits = "01234567";
       break;
    case 'd': case 'D':
       digits = "0123456789";
       break;
    case 'h': case 'x':
       digits = "0123456789abcdef";
       break;
    case 'H': case 'X':
       digits = "0123456789ABCDEF";
       break;
    case '\0':
       fprintf(stderr,"%s: null base specifier `%s'\n",argvec[0],origarg);
       errs = 1;
       return;
       break;
    default:
       if (*arg == '\0')
	{ fprintf(stderr,"%s: unknown base key `%c' (or base 1)\n",
			argvec[0],arg[-1]);
	  errs = 1;
	  return;
	}
       digits = arg-1;
       arg = "";
       break;
  }
 if (*arg)
  { fprintf(stderr,"%s: junk `%s' at end of base spec `%s'\n",
				argvec[0],arg,origarg);
    errs = 1;
    return;
  }
 ndig = strlen(digits) * (isneg ? -1 : 1);
}

main(ac,av)
int ac;
char **av;
{
 long int value;

argvec=av;/*grrr...*/
 if (ac < 3)
  { fprintf(stderr,"Usage: %s <input-base> <output-base>\n",
			argvec[0]);
    exit(1);
  }
 errs = 0;
 get_base(av[1],&indig,&idigits,&isign);
 get_base(av[2],&ondig,&odigits,&osign);
 if (errs)
  { exit(1);
  }
 while (1)
  { value = get_number(indig,idigits,isign);
    put_number(ondig,odigits,osign,value);
  }
}
