/*
 * myperror.c - unbuffered version of stdio perror(3s)
 *
 * author: Maarten Litmaath @ VU Informatika Amsterdam (maart@cs.vu.nl)
 */

#define		ERRBUF_SIZE		32


void	myperror(s)
char	*s;
{
	extern	int	errno, sys_nerr;
	extern	char	*sys_errlist[];
	register char	*p;
	register int	n = 0;
	int	min = 0;
	char	buf[ERRBUF_SIZE];


	if (s && *s) {
		(void) write(2, s, strlen(s));
		(void) write(2, ": ", 2);
	}

	if (0 <= errno && errno < sys_nerr)
		p = sys_errlist[errno];
	else {
		p ="Unknown error ";
		n = errno;
	}

	(void) write(2, p, strlen(p));

	if (n) {
		p = buf + sizeof buf;
		if (n < 0) {
			min = 1;
			n *= -1;
		}
		while (n) {
			*--p = '0' + n % 10;
			n /= 10;
		}
		if (min)
			*--p = '-';
		(void) write(2, p, buf + sizeof buf - p);
	}
	(void) write(2, "\n", 1);
}
