/*
 * ctrl.c - translate printable characters to corresponding control characters
 *          doesn't use stdio, to keep the size small
 *
 * author: Maarten Litmaath @ VU Informatika Amsterdam (maart@cs.vu.nl)
 */

#define		BUF_SIZE	1024


int	ctrl(), unesc(), esc(), bell();

struct	func {
		char	*name;
		int	(*func)();
	} ftab[] = {
		{ "ctrl", ctrl },
		{ "unesc", unesc },
		{ "esc", esc },
		{ 0, bell }
	};


main(argc, argv)
int	argc;
register char	**argv;
{
	struct	func	*f = ftab;
	char	buf[BUF_SIZE], *name, *rindex();
	int	n, status = 0;
	void	myperror();


	if (!(name = rindex(*argv, '/')))
		name = *argv;
	else
		++name;
	++argv;

	while (f->name && strcmp(f->name, name) != 0)
		++f;

	n = (*f->func)(argv, buf);

	if (write(1, buf, n) != n) {
		myperror(name);
		status = 1;
	}

	_exit(status);
}


int	ctrl(argv, buf)
register char	**argv;
char	*buf;
{
	register char	*s, *p = buf, c;


	while (s = *argv++) {
		while (c = *s++)
			*p++ = '?' <= c && c <= '_' ? c ^ 0100 : c;
		*p++ = ' ';
	}

	if (p != buf)
		--p;

	*p++ = '\n';
	*p = '\0';

	return p - buf;
}


int	unesc(argv, buf)
register char	**argv;
char	*buf;
{
	register char	*s, *p = buf, c;


	while (s = *argv++) {
		while (c = *s++)
			switch (c) {
			case '\\':
				*p++ = *s ? *s++ : c;
				break;
			case '^':
				*p++ = '?' <= *s && *s <= '_' ? *s++ ^ 0100 :
					*s ? *s++ : c;
				break;
			default:
				*p++ = c;
				break;
			}
		*p++ = ' ';
	}

	if (p != buf)
		--p;

	*p++ = '\n';
	*p = '\0';

	return p - buf;
}


int	esc(argv, buf)
char	**argv;
register char	*buf;
{
	*buf++ = '\033';
	*buf++ = '\n';
	*buf = '\0';
	return 2;
}


int	bell(argv, buf)
char	**argv, *buf;
{
	register char	*p = buf;
	register int	n = *argv ? atoi(*argv) : 1;


	while (--n >= 0)
		*p++ = '\007';

	*p++ = '\n';
	*p = '\0';
	return p - buf;
}
