/*
 * cronsort - chronilogically sort the crontab file by
 *            record, and by fields within each record
*/
#include <stdio.h>

#ifdef DEBUG
#define CRONTAB "crontab" 
#else
#define CRONTAB "/usr/lib/crontab" 
#endif

#define FS      50       /* Maximum field size for each crontab field */

#define RECSIZ  BUFSIZ   /* RECSIZ must be at least as long as longest 
                            CRONTAB entry. BUFSIZ if from <stdio.h> */
struct entry {
               int     num;            /* encoded value of time   */
               char    record[BUFSIZ]; /* a crontab entry         */
               struct entry *next;     /* next entry in chain     */
             } ;

struct eplist {
                int      num;         /* encoded accumlitive time values */
                struct entry *pentry; /* points to struct that num came from */
              } *eplist;
int entries = 0;   /* will need to know how many struct entries there are */

main(argc,argv)
  int    argc;
  char **argv;
{
   void Sortmoy(), Swaps();
   int i,error = 0, wflag = 0;
   char c;
   char dow[FS],moy[FS],dom[FS],hr[FS],min[FS];
   char record[RECSIZ], progname[BUFSIZ];
   struct entry *entry, *top;
   struct eplist *teplist;
   FILE *fd;

   strcat(progname,*argv);
   for(++argv; *argv!=NULL; argv++){
      if(!strcmp(*argv,"-w"))
        wflag = 1;
      else if (!strcmp(*argv,"-m"))
        wflag = 0;
      else
        error = 1;
  }

   if(error) {
     fprintf(stderr,"Syntex: %s [ -[wm] ] \n",progname);
     fprintf(stderr,"  where  -w  will sort by day of week\n");
     fprintf(stderr,"         -m  will sort by day of month (default)\n");
     exit(0);
   }

   if( (fd = fopen(CRONTAB,"r")) == NULL) {
      perror(*argv);
      exit(0);
   }

   top = (struct entry *)NULL; /* intialize pointer to NULL, keep lint happy */
   while( (fgets(record,RECSIZ,fd)) != NULL) { /* read the records */
     sscanf(record,"%c %*s",&c);
     if( !Isdigit(c) && c != '*')
       continue;  /* crontab record format error or just a comment */

     if(top == NULL) {
         entry = (struct entry *)malloc(sizeof(struct entry));
         top = entry; /* top; i.e. top of list. Value should never be changed */
     }
     else { /* add another structure to hold the record and stuf */
         entry->next = (struct entry *)malloc(sizeof(struct entry));
         entry = entry->next;
         entry->next = NULL;
     }
     entries++;

     /* store it for printing later */
     strcat(entry->record,record); /* source of later output */

     /* break it up into manageable pieces */
     sscanf(record,"%s%s%s%s%s%*s",min,hr,dom,moy,dow);

     /* store the pieces so we can sort them later */
     entry->num = (Parse(moy) * 100000) +
                  ( (wflag ? Parse(dow) : Parse(dom)) * 10000) +
                  (Parse(hr) * 100 ) + Parse(min) ;
   }

   /* create an array of struct pointers and integers so we will only
   *  need a single sort routine */
   eplist = (struct eplist *)malloc(sizeof(struct eplist) * entries );

   /* load eplist with addresses for each struct entry */
   for(teplist=eplist,entry = top;  ; teplist++,entry=entry->next) {
      teplist->num = entry->num;
      teplist->pentry = entry;
      if(entry->next == NULL)
         break;
   }
   Sortint(eplist);
   
   /**** Print the resulting sort  ****/
   for(i=0,teplist=eplist; i < entries ; i++, teplist++) {
     entry = teplist->pentry;
     printf("%s",entry->record); /* Don't need newline, it's in record */
   }
}

/****** Isdigit() ********/
Isdigit(c)
  char c;
{
   return( c>='0' && c<='9' ? c : NULL);
}

/******* Parse() *******/
Parse(field)
  char *field;
{
   int num, Num = 99;  /* Num set to some out-of-range value */
   char *p;

   p = field;

   /* align pointer to first digit */
   if(*p == '*')   /* wild card, takes precedent over explicit values */
     return(0);


  while(*p) {        /* scan the field til NULL, find lowest value within */
   if(Isdigit(*p)) {
      num = (int)( (*p) - '0');
      p++;
      if(Isdigit(*p)) {
         num = (num *10) + (int)( (*p) - '0');
      }
   }
   p++;
   Num = num < Num ? num : Num;
  }
  return(Num + 1); /* since an asteric is evaluated as zero (above) */
}

/******* Sortint() ********
 sort numeric data, swapping order also requires swapping the pointer
 to the struct entry that contains a copy of the data.
*/
Sortint(list)
  struct eplist *list;
{
  register struct eplist *top, *chain;
  register int ol, il ; /* Outter Loop, Inner Loop */
  register struct entry *tmp;
  int tmpnum, swapped = 0;

  chain = list;
  for(ol=entries; ol > 0 ;ol--) {
     if( chain->pentry == NULL )
        break;
     for(il=0,chain = list; il < ol; il++,chain++) {
       if( (chain + 1)->pentry == NULL )
          break;
       if(chain->num > (chain + 1)->num) {
          /* do a swap */
          tmp = chain->pentry;
          tmpnum = chain->num;

          chain->pentry = (chain + 1)->pentry;
          chain->num = (chain + 1)->num;

          (chain + 1)->pentry = tmp;
          (chain + 1)->num = tmpnum;
          swapped = 1;
       }
     }
   if(!swapped) /* A pass with no swapping means we've finnished early */
     break;
  }
}
