
/*
 * chemtab - a periodic table data base (C) 1990 Jim King (pulsar@lsrhs)
 *
 * esort.c	Takes the changed values to look for and sifts to sub1[]
 */

#include "element.h"
#include "undefs.h"
#include "variables.h"
#include "tune.h"
#include <curses.h>
#include "windows.h"

int	sift[3][MAXLM],	/* Enough spaces to carry all the elements through
			   the sifting process 3 times. */
	sftc[3];	/* number telling the amount of elements in sift[x] */
int	tmp[MAXLM],	/* A place to put compared elements from 1&2 & 2&3 */
	tc;		/* The temp[x] counter */

/*
 * esort() - no input
 *
 * purpose:	Take the selecting characteristics from dosort[x] which are
 *		defined in schar() and sift the elements through them, then
 *		see what's left and store it away.
 */
esort()
{
	x = 0.0;			/* floating integer for cmp */

	if (dosort[0].wch == 0)			/* No chars to sort */
		return(1);

	tc = gtot = 0;				/* Reset counter */
	for (i = 0; i < MAXLM; i++) {
		sub1[i] = 0;			/* Clear the olds */
		sift[0][i] = sift[1][i] = sift[2][i] = 0;
		sftc[0] = sftc[1] = sftc[2] = 0;
		tmp[i] = 0;
	}
	for (i = 0; i < 3; i++) {
		if (dosort[i].wch != 0) {	/* Sort on this */
			for (k = 1; k < MAXLM; k++) {
				switch(dosort[i].wch) {
					case 1: x = e[k].anum;  break;
					case 2: x = e[k].amass; break;
					case 3: x = e[k].fam;   break;
					case 4: x = e[k].row;   break;
					case 5: x = e[k].val;   break;
					case 6: x = e[k].melt;  break;
					case 7: x = e[k].boil; 	break;
					case 8: x = e[k].fio;   break;
					case 9: x = e[k].year;  break;
					case 10: x = e[k].eneg; break;
					case 11: x = e[k].spht; break;
					case 12: x = e[k].dens;	break;
					case 13: x = e[k].arad; break;
					default:                break;
				}
				if ((x > dosort[i].amt && dosort[i].sgn == GREATER) ||
				    (x < dosort[i].amt && dosort[i].sgn == LESS) ||
				    (x == dosort[i].amt && dosort[i].sgn == EQUAL) ||
				    (x >= dosort[i].amt - close[dosort[i].wch] && x <= dosort[i].amt + close[dosort[i].wch] && dosort[i].sgn == CLOSE)) {
					if (!((dosort[i].wch == 5 && x == VAL) ||
					    (dosort[i].wch == 6 && x == MEL) ||
					    (dosort[i].wch == 7 && x == BOI) ||
					    (dosort[i].wch == 8 && x == FIO) ||
					    (dosort[i].wch == 10 && x == ENG) ||
					    (dosort[i].wch == 11 && x == SPHT) ||
					    (dosort[i].wch == 12 && x == DENS) ||
					    (dosort[i].wch == 13 && x == ARD))) {
						sftc[i]++;
						sift[i][sftc[i]] = k;
					    }
				}
			}
		}
	}
					/* Now sift each to other */
					/* Compare 1 and 2 into tmp[] */
	if (dosort[1].wch == 0) {	/* Only 1 sort */
		for (i = 1; i < MAXLM; i++) /* Copy sift[0] into sub1 */
			sub1[i] = sift[0][i];
		goto end;
	}
	for (j = 1; j < MAXLM; j++) {	/* Compare sift[1] and sift[0] */
		if (sift[0][j] != 0) {	/* If something to compare */
			for (k = 1; k < MAXLM; k++) {
				if (sift[0][j] == sift[1][k]) {
					tc++;	/* Match */
					tmp[tc] = sift[0][j];
				}
			}
		}
	}
	if (dosort[2].wch == 0) {	/* Only 2 sorts */
		for (i = 1; i < MAXLM; i++) /* Copy tmp into sub1 */
			sub1[i] = tmp[i];
		goto end;
	}
					/* Now sift tmp[] with sift[2] */
	for (i = 1; i < MAXLM; i++) {
		if (tmp[i] != 0) {
			for (j = 1; j < MAXLM; j++) {
				if (tmp[i] == sift[2][j]) {
					++gtot;
					sub1[gtot] = tmp[i]; /* Match */
				}
			}
		}
	}
	goto rend;
end:	for (i = 1; i < MAXLM; i++) {
		if (sub1[i] != 0)
			gtot++;
	}
rend:	/* This is the end! */
	tc = 0;
	return(0);
}
