
/*
 * chemtab - a periodic table data base (C) 1990 Jim King (pulsar@lsrhs)
 *
 * vdata.c	View current data
 */

#include <stdio.h>
#include <curses.h>
#include "variables.h"
#include "tune.h"
#include "element.h"
#include "windows.h"
#include "undefs.h"

/*
 * topline() - no input
 *
 * purpose:	sets up the topline of user info.
 */
topline()
{
	mvwaddstr(graph, 0, 0, "Name");
	mvwaddstr(graph, 0, 13, "Sy");
	mvwaddstr(graph, 0, 18, "Z");
	mvwaddstr(graph, 0, 22, "M");
	mvwaddstr(graph, 0, 26, "FM");
	mvwaddstr(graph, 0, 29, "R");
	mvwaddstr(graph, 0, 31, "V");
	mvwaddstr(graph, 0, 33, "Melt");
	mvwaddstr(graph, 0, 38, "Boil");
	mvwaddstr(graph, 0, 43, "FIO");
	mvwaddstr(graph, 0, 47, "Year");
	mvwaddstr(graph, 0, 52, "ENG");
	mvwaddstr(graph, 0, 56, "SPHT");
	mvwaddstr(graph, 0, 61, "DENS");
	mvwaddstr(graph, 0, 66, "ARAD");
	wrefresh(graph);
}

/*
 * vdata() - no input
 *
 * purpose:	show all information on all selected elements to user
 */
vdata()
{
	int	n = 0, flg = 0, factor = 1, l, m;

	wclear(mn);
	wrefresh(mn);

	clear();
	wclear(graph);
	wrefresh(graph);
	refresh();
	topline();
	if (gtot == 0) {
		mvwaddstr(graph, 5, 0, "No elements met the requirements you set.");
		wrefresh(graph);
		spc();
		clear();
		refresh();
		return(0);
	}
	sprintf(str, "GTOT = %d", gtot);
	bot(str);
	if (gtot > 22)
		factor++;
	if (gtot > 44)
		factor++;
	if (gtot > 66)
		factor++;
	if (gtot > 88)
		factor++;
	for (i = 0; i < factor; i++) {
		for (j = 22*i+1; j < 22*i+23; j++) {
			if (j > gtot)
				break;
			n = sub1[j];
			mvwaddstr(graph, j-22*i, 0, e[n].name);
			wmove(graph, j-22*i, 13); wprintw(graph, "%s", e[n].sym);
			wmove(graph, j-22*i, 18); wprintw(graph, "%-d", e[n].anum);
			wmove(graph, j-22*i, 22); wprintw(graph, "%-d", e[n].amass);
			wmove(graph, j-22*i, 26); wprintw(graph, "%-d", e[n].fam);
			wmove(graph, j-22*i, 29); wprintw(graph, "%-d", e[n].row);
			if (e[n].val == VAL) {
				wstandout(graph);
				mvwaddstr(graph, j-22*1, 31, "X");
				wstandend(graph);
			} else {
				wmove(graph, j-22*i, 31); wprintw(graph, "%d", e[n].val);
			}
			if (e[n].melt == MEL) {
				wstandout(graph);
				mvwaddstr(graph, j-22*i, 33, "N/F");
				wstandend(graph);
			} else {
				wmove(graph, j-22*i, 33); wprintw(graph, "%-d", e[n].melt);
			}
			if (e[n].boil == BOI) {
				wstandout(graph);
				mvwaddstr(graph, j-22*i, 38, "N/F");
				wstandend(graph);
			} else {
				wmove(graph, j-22*i, 38); wprintw(graph, "%-d", e[n].boil);
			}
			if (e[n].fio == FIO) {
				wstandout(graph);
				mvwaddstr(graph, j-22*i, 43, "N/F");
				wstandend(graph);
			} else {
				wmove(graph, j-22*i, 43); wprintw(graph, "%3d", e[n].fio);
			}
			if (e[n].year == YEA) {
				wstandout(graph);
				mvwaddstr(graph, j-22*i, 47, "B.C.");
				wstandend(graph);
			} else {
				wmove(graph, j-22*i, 47); wprintw(graph, "%-d", e[n].year);
			}
			if (e[n].eneg == ENG) {
				wstandout(graph);
				mvwaddstr(graph, j-22*i, 52, "N/F");
				wstandend(graph);
			} else {
				wmove(graph, j-22*i, 52); wprintw(graph, "%1.1f", e[n].eneg);
			}
			if (e[n].spht == SPHT) {
				wstandout(graph);
				mvwaddstr(graph, j-22*i, 56, "N/F");
				wstandend(graph);
			} else {
				wmove(graph, j-22*i, 56); wprintw(graph, "%1.2f", e[n].spht);
			}
			if (e[n].dens == DENS) {
				wstandout(graph);
				mvwaddstr(graph, j-22*i, 61, "N/F");
				wstandend(graph);
			} else {
				wmove(graph, j-22*i, 61);
				if (e[n].dens > 9.99)
					wprintw(graph, "%2.1f", e[n].dens);
				else
					wprintw(graph, "%1.2f", e[n].dens);
			}
			if (e[n].arad == ARD) {
				wstandout(graph);
				mvwaddstr(graph, j-22*i, 66, "N/F");
				wstandend(graph);
			} else {
				wmove(graph, j-22*i, 66); wprintw(graph, "%1.2f", e[n].arad);
			}
			wrefresh(graph);
		}
		spc();
		capture(graph, 0, 1);
		wclear(graph);
		topline();
	}
	clear();
	refresh();
	return(0);
}
