/*
 * Chemtab - a periodic table data base (C) 1990 Jim King (pulsar@lsrhs)
 *
 * schar.c	Interface with user for sorting
 */

#include <stdio.h>
#include <curses.h>
#include "element.h"
#include "variables.h"
#include "windows.h"
#include "tune.h"

/*
 * whichone() - no input
 *
 * purpose:	to find out how many characteristics we are sorting already
 */
whichone()
{
	if (dosort[2].wch != 0)
		return(3);
	if (dosort[1].wch != 0)
		return(2);
	if (dosort[0].wch != 0)
		return(1);
	return(0);
}

/*
 * tablsort() - no input
 *
 * purpose:	Put characteristics on table window
 */
tablsort()
{
	for (i = 0; i < 3; i++) {
		if (dosort[i].wch != 0) {
			wmove(graph, i*4, 57);
			wstandout(graph);
			wprintw(graph, "%s", sopts[dosort[i].wch].chst);
			wstandend(graph);
			switch(dosort[i].sgn) {
				case EQUAL: mvwaddstr(graph, i*4+1, 58, "is Equal to"); break;
				case GREATER: wmove(graph, i*4+1, 58); wprintw(graph, "is %s", sopts[dosort[i].wch].upline); break;
				case CLOSE: mvwaddstr(graph, i*4+1, 58, "is Close to"); break;
				default: wmove(graph, i*4+1, 58); wprintw(graph, "is %s", sopts[dosort[i].wch].dnline); break;
			}
			wmove(graph, i*4+2, 59);
			wprintw(graph, "%4.*f", sopts[dosort[i].wch].dnum, dosort[i].amt);
		}
	}
	wrefresh(graph);
}

/*
 * upsort() - no input
 *
 * purpose:	Update the sort window
 */
upsort()
{
	wclear(srt);
	mvwaddstr(srt, 0, 0, "Current selecting characteristics: (max of 3)");
	for (i = 0; i < 3; i++) {
		if (dosort[i].wch != 0) {
			wmove(srt, i+2, 0);
			wstandout(srt);
			wprintw(srt, "%s", sopts[dosort[i].wch].chst);
			wstandend(srt);
			switch(dosort[i].sgn) {
				case EQUAL: wprintw(srt, " is Equal to "); break;
				case GREATER: wprintw(srt, " is %s ", sopts[dosort[i].wch].upline); break;
				case LESS: wprintw(srt, " is %s ", sopts[dosort[i].wch].dnline); break;
				case CLOSE: wprintw(srt, " is Close to "); break;
			}
			wprintw(srt, "%4.*f", sopts[dosort[i].wch].dnum, dosort[i].amt);
		}
	}
	wrefresh(srt);
}

/*
 * schar() - no input
 *
 * purpose:	Interface with user to select sorting characteristics
 *		to sort elements from
 */
schar()
{
	int	n, cur;

	noecho();
	crmode();
lop1:	clear(); refresh();
	for (;;) {
lop2:		upsort();				/* Update sorts */
		wclear(mn); wrefresh(mn);
		for (i = 1; i < 8; i++) {
			wmove(mn, i, 0);
			wprintw(mn, "%d] %s", i, sopts[i].chst);
			wmove(mn, i, 40);
			wprintw(mn, "%d] %s", i+7, sopts[i+7].chst);
		}
		wmove(mn, 8, 40);
		wprintw(mn, "15] %s", sopts[15].chst);
		mvwaddstr(mn, 10, 0, "Your Choice? ");
		wclrtoeol(mn);
		if (hlp)
			mvwaddstr(mn, 10, 16, "(type number of choice and press return)");
		mvwaddstr(mn, 10, 12, " ");
		wrefresh(mn);
		echo();
		nocrmode();
		gets(str);
		n = atoi(str);
		switch(n) {
			case 14:		/* Main Menu */
				esort();
				return(0);
			case 15:		/* Clear all chars */
				mvwaddstr(mn, 10, 0, "Are you sure? ");
				wrefresh(mn);
				noecho();
				crmode();
				if (wgetch(mn) == 'y') {
					for (i = 0; i < 3; i++)
						dosort[i].wch = 0;
				}
				wmove(mn, 10, 0); wclrtoeol(mn);
				wrefresh(mn);
				goto lop1;
			default:
				if (n < 1 || n > 15)
					goto lop2;
				else
					break;
		}
		cur = whichone();
		if (dosort[0].wch == n || dosort[1].wch == n) {
			bot("This characteristic is already being sorted.");
			sleep(3);
			bot(" ");
			mvwaddstr(btm, 0, 0, "Do you wish to change this characteristic? ");
			wrefresh(btm);
			noecho(); crmode();
			if (getchar() == 'y') {
				bot(" ");
				for (i = 0; i < 2; i++) {
					if (dosort[i].wch == n)
						cur = i;
				}
				goto lop3;
			} else {
				mvwaddstr(btm, 0, 0, "Do you wish to make another characteristic of the same type?");
				wrefresh(btm);
				noecho(); crmode();
				if (getchar() != 'y') {
					wclear(btm); wrefresh(btm);
					goto lop2;
				}
			}
		}
		if (cur > 2) {
			bot("Maximum of three sorting characteristics");
			sleep(3);
			bot(" ");
			goto lop2;
		}
lop3:		dosort[cur].wch = n;
		wclear(mn); wrefresh(mn);
		wmove(mn, 1, 0);
		wprintw(mn, "You would like to select some elements with their '%s' being", sopts[n].chst);
		mvwaddstr(mn, 3, 0, "1] Equal To");
		wmove(mn, 4, 0); wprintw(mn, "2] %s", sopts[n].upline);
		wmove(mn, 5, 0); wprintw(mn, "3] %s", sopts[n].dnline);
		mvwaddstr(mn, 6, 0, "4] Close To");
		wmove(mn, 7, 0); wprintw(mn, "5] Exit (will erase characteristic)");
		mvwaddstr(mn, 9, 9, "the amount you select next.");
		if (hlp)
			mvwaddstr(mn, 11, 16, "(type in number of choice, do not hit return)");
lop4:		mvwaddstr(mn, 11, 0, "Your Choice? ");
		wrefresh(mn);
		noecho();
		crmode();
		switch(getchar()) {
			case '1': dosort[cur].sgn = EQUAL;	break;
			case '2': dosort[cur].sgn = GREATER;	break;
			case '3': dosort[cur].sgn = LESS;	break;
			case '4': dosort[cur].sgn = CLOSE;	break;
			case '5': dosort[cur].wch = 0;		goto lop1;
			default:
				goto lop4;
		}
		wclear(mn);
		wrefresh(mn);
		wmove(mn, 1, 0);
		wprintw(mn, "You want to select some elements with the '%s' being ", sopts[n].chst);
		switch(dosort[cur].sgn) {
			case EQUAL:
				wprintw(mn, "Equal to");
				break;
			case GREATER:
				wprintw(mn, "%s", sopts[n].upline);
				break;
			case CLOSE:
				wprintw(mn, "Close to");
				break;
			default:
				wprintw(mn, "%s", sopts[n].dnline);
				break;
		}
		if (hlp)
			mvwaddstr(mn, 3, 21, "(type in a number then hit return.  Decimals are allowed)");
lop5:		mvwaddstr(mn, 3, 0, "What Amount? ");
		wclrtoeol(mn);
		wrefresh(mn);
		echo();
		nocrmode();
		scanf("%f", &dosort[cur].amt);
		if (dosort[cur].amt > 9999) {
			bot("Maximum amount is 9999.");
			sleep(3);
			bot(" ");
			goto lop5;
		}
		getchar();		/* Eat the \n that scanf doesn't */
	}
}
